/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.ui.PostgreCreateDatabaseDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionAtomic;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseManager
extends SQLObjectEditor<PostgreDatabase, PostgreDataSource>
implements DBEObjectRenamer<PostgreDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<PostgreDataSource, PostgreDatabase> getObjectsCache(PostgreDatabase object) {
        return object.getDataSource().getDatabaseCache();
    }

    protected PostgreDatabase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final PostgreDataSource parent, Object copyFrom) {
        return (PostgreDatabase)new UITask<PostgreDatabase>(){

            protected PostgreDatabase runTask() {
                PostgreCreateDatabaseDialog dialog = new PostgreCreateDatabaseDialog(DBeaverUI.getActiveWorkbenchShell(), parent);
                if (dialog.open() != 0) {
                    return null;
                }
                return new PostgreDatabase(parent, dialog.getName(), dialog.getOwner(), dialog.getTemplateName(), dialog.getTablespace(), dialog.getEncoding());
            }
        }.execute();
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        PostgreDatabase database = (PostgreDatabase)command.getObject();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE DATABASE ").append(DBUtils.getQuotedIdentifier((DBSObject)database));
        try {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            if (database.getDBA((DBRProgressMonitor)monitor) != null) {
                sql.append("\nOWNER = ").append(database.getDBA((DBRProgressMonitor)monitor).getName());
            }
            if (!CommonUtils.isEmpty((String)database.getTemplateName())) {
                sql.append("\nTEMPLATE = ").append(database.getTemplateName());
            }
            if (database.getDefaultEncoding((DBRProgressMonitor)monitor) != null) {
                sql.append("\nENCODING = '").append(database.getDefaultEncoding((DBRProgressMonitor)monitor).getName()).append("'");
            }
            if (database.getDefaultTablespace((DBRProgressMonitor)monitor) != null) {
                sql.append("\nTABLESPACE = ").append(database.getDefaultTablespace((DBRProgressMonitor)monitor).getName());
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Create database", sql.toString()));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Drop database", "DROP DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }

    public void renameObject(DBECommandContext commandContext, PostgreDatabase catalog, String newName) throws DBException {
        throw new DBException("Direct database rename is not yet implemented in PostgreSQL. You should use export/import functions for that.");
    }
}

