/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreUtils {
    private static final Log log = Log.getLog(PostgreUtils.class);
    private static final int UNKNOWN_LENGTH = -1;
    private static Method getValueMethod;

    public static String getObjectComment(DBRProgressMonitor monitor, DBPDataSource dataSource, String schema, String object) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Load PostgreSQL description");){
                return JDBCUtils.queryString((JDBCSession)session, (String)"select description from pg_description\njoin pg_class on pg_description.objoid = pg_class.oid\njoin pg_namespace on pg_class.relnamespace = pg_namespace.oid\nwhere pg_class.relname = ? and pg_namespace.nspname=?", (Object[])new Object[]{object, schema});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    public static String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "bool";
            }
            case NUMERIC: {
                return "int";
            }
            case STRING: {
                return "varchar";
            }
            case DATETIME: {
                return "timestamp";
            }
            case BINARY: {
                return "bytea";
            }
            case CONTENT: {
                return "bytea";
            }
            case ROWID: {
                return "oid";
            }
        }
        return "varchar";
    }

    public static <T extends PostgreAttribute> T getAttributeByNum(Collection<T> attrs, int attNum) {
        for (PostgreAttribute attr : attrs) {
            if (attr.getOrdinalPosition() != attNum) continue;
            return (T)((Object)attr);
        }
        return null;
    }

    public static boolean isPGObject(Object object) {
        return object != null && object.getClass().getName().equals("org.postgresql.util.PGobject");
    }

    public static <T> T extractPGObjectValue(Object pgObject) {
        if (pgObject == null) {
            return null;
        }
        if (getValueMethod == null) {
            try {
                getValueMethod = pgObject.getClass().getMethod("getValue", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)e);
            }
        }
        if (getValueMethod != null) {
            try {
                return (T)getValueMethod.invoke(pgObject, new Object[0]);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return null;
    }

    @Nullable
    public static <OWNER extends DBSObject, OBJECT extends PostgreObject> OBJECT getObjectById(@NotNull DBRProgressMonitor monitor, @NotNull AbstractObjectCache<OWNER, OBJECT> cache, @NotNull OWNER owner, long objectId) throws DBException {
        for (PostgreObject object : cache.getAllObjects(monitor, owner)) {
            if (object.getObjectId() != objectId) continue;
            return (OBJECT)object;
        }
        return null;
    }

    public static long[] getIdVector(Object pgObject) {
        Object pgVector = PostgreUtils.extractPGObjectValue(pgObject);
        if (pgVector == null) {
            return null;
        }
        if (pgVector instanceof String) {
            String vector = (String)pgVector;
            if (vector.isEmpty()) {
                return null;
            }
            String[] strings = vector.split(" ");
            long[] ids = new long[strings.length];
            int i = 0;
            while (i < strings.length) {
                ids[i] = Long.parseLong(strings[i]);
                ++i;
            }
            return ids;
        }
        if (pgVector instanceof long[]) {
            return (long[])pgVector;
        }
        if (pgVector instanceof Long[]) {
            Long[] objVector = (Long[])pgVector;
            long[] result = new long[objVector.length];
            int i = 0;
            while (i < objVector.length) {
                result[i] = objVector[i];
                ++i;
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported vector type: " + pgVector.getClass().getName());
    }

    public static int[] getIntVector(Object pgObject) {
        Object pgVector = PostgreUtils.extractPGObjectValue(pgObject);
        if (pgVector == null) {
            return null;
        }
        if (pgVector instanceof String) {
            String vector = (String)pgVector;
            if (vector.isEmpty()) {
                return null;
            }
            String[] strings = vector.split(" ");
            int[] ids = new int[strings.length];
            int i = 0;
            while (i < strings.length) {
                ids[i] = Integer.parseInt(strings[i]);
                ++i;
            }
            return ids;
        }
        if (pgVector instanceof int[]) {
            return (int[])pgVector;
        }
        if (pgVector instanceof Integer[]) {
            Integer[] objVector = (Integer[])pgVector;
            int[] result = new int[objVector.length];
            int i = 0;
            while (i < objVector.length) {
                result[i] = objVector[i];
                ++i;
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported vector type: " + pgVector.getClass().getName());
    }

    public static int getAttributePrecision(long typeOid, int typeMod) {
        switch ((int)typeOid) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typeMod == -1) {
                    return 0;
                }
                return (typeMod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: {
                if (typeMod == -1) {
                    return -1;
                }
                return typeMod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return PostgreUtils.getDisplaySize(typeOid, typeMod);
            }
            case 1560: {
                return typeMod;
            }
            case 1562: {
                if (typeMod == -1) {
                    return -1;
                }
                return typeMod;
            }
        }
        return -1;
    }

    public static int getDisplaySize(long oid, int typmod) {
        switch ((int)oid) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 15;
            }
            case 701: {
                return 25;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int secondSize;
                switch (typmod) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = typmod + 1;
                    }
                }
                switch ((int)oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return -1;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return -1;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return -1;
            }
        }
        return -1;
    }

    public static int getScale(long oid, int typmod) {
        switch ((int)oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    public static PostgreDataType findDataType(PostgreDataSource dataSource, DBSTypedObject type) {
        if (type instanceof PostgreAttribute) {
            return ((PostgreAttribute)type).getDataType();
        }
        String typeName = type.getTypeName();
        return dataSource.getLocalDataType(typeName);
    }

    public static Object convertStringToValue(DBSTypedObject itemType, String string, boolean unescape) {
        switch (itemType.getTypeID()) {
            case 16: {
                return Boolean.valueOf(string);
            }
            case -6: {
                return Byte.parseByte(string);
            }
            case 5: {
                return Short.parseShort(string);
            }
            case 4: {
                return Integer.parseInt(string);
            }
            case -5: {
                return Long.parseLong(string);
            }
            case 6: {
                return Float.valueOf(Float.parseFloat(string));
            }
            case 7: 
            case 8: {
                return Double.parseDouble(string);
            }
        }
        return string;
    }

    public static String[] parseObjectString(String string) throws DBCException {
        if (string.isEmpty()) {
            return new String[0];
        }
        try {
            return new CSVReader((Reader)new StringReader(string)).readNext();
        }
        catch (IOException e) {
            throw new DBCException("Error parsing PGObject", (Throwable)e);
        }
    }

    public static String generateObjectString(Object[] values) throws DBCException {
        String[] line = new String[values.length];
        int i = 0;
        while (i < values.length) {
            Object value = values[i];
            line[i] = value == null ? "NULL" : value.toString();
            ++i;
        }
        StringWriter out = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)out);
        writer.writeNext(line);
        try {
            writer.flush();
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
        return "(" + out.toString().trim() + ")";
    }

    public static void setArrayParameter(JDBCPreparedStatement dbStat, int index, List<? extends PostgreObject> objectList) throws SQLException {
        int i = 0;
        while (i < objectList.size()) {
            dbStat.setLong(index + i, objectList.get(i).getObjectId());
            ++i;
        }
    }

    public static String getViewDDL(PostgreViewBase view, String definition) {
        String createSQL = view instanceof PostgreView ? "CREATE OR REPLACE " : "CREATE ";
        return String.valueOf(createSQL) + view.getViewType() + " " + view.getFullyQualifiedName(DBPEvaluationContext.DDL) + " AS\n" + definition;
    }
}

