/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.views;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorAbstractUI;
import org.jkiss.utils.CommonUtils;

public class CasSSLConfigurator
extends SSLConfiguratorAbstractUI {
    private TextWithOpen trustStorePath;
    private Text trustStorePassword;
    private TextWithOpen clientCertPath;
    private TextWithOpen clientKeyPath;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)composite, (String)"You can choose SSL context configuration type");
        Group certGroup = UIUtils.createControlGroup((Composite)composite, (String)"Trust Store", (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)certGroup, (String)"Client Trust Store");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.trustStorePath = new TextWithOpenFile((Composite)certGroup, "Client Trust Store", new String[]{"*.*", "*.jks", "*"});
        this.trustStorePath.setLayoutData((Object)new GridData(768));
        this.trustStorePassword = UIUtils.createLabelText((Composite)certGroup, (String)"Trust Store password", (String)"", (int)0x400800);
        gd = new GridData(32);
        gd.widthHint = 130;
        this.trustStorePassword.setLayoutData((Object)gd);
        CLabel label = UIUtils.createInfoLabel((Composite)certGroup, (String)"Trust store file must be in Java KeyStore format (jks)");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        certGroup = UIUtils.createControlGroup((Composite)composite, (String)"Client Authentication", (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)certGroup, (String)"Client Certificate");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientCertPath = new TextWithOpenFile((Composite)certGroup, "Client Certificate", new String[]{"*.*", "*.crt", "*"});
        this.clientCertPath.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)certGroup, (String)"Client Key");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientKeyPath = new TextWithOpenFile((Composite)certGroup, "Client Key", new String[]{"*.*", "*.key", "*"});
        this.clientKeyPath.setLayoutData((Object)new GridData(768));
        label = UIUtils.createInfoLabel((Composite)certGroup, (String)"Use it if you have client certificate and private key");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        this.trustStorePath.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.trustStore"))));
        this.trustStorePassword.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.trustStorePassword"))));
        this.clientCertPath.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.client.cert"))));
        this.clientKeyPath.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.client.key"))));
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.getProperties().put("ssl.trustStore", this.trustStorePath.getText());
        configuration.getProperties().put("ssl.trustStorePassword", this.trustStorePassword.getText());
        configuration.getProperties().put("ssl.client.cert", this.clientCertPath.getText());
        configuration.getProperties().put("ssl.client.key", this.clientKeyPath.getText());
    }
}

