/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.model;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.dbeaver.ent.cassandra.model.CasKeyspace;
import com.dbeaver.ent.cassandra.model.CasTableBase;
import com.dbeaver.ent.cassandra.model.CasTableKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;

public class CasMView
extends CasTableBase {
    private static final Log log = Log.getLog(CasMView.class);
    private final MaterializedViewMetadata metadata;

    public CasMView(CasKeyspace keyspace, MaterializedViewMetadata metadata) {
        super(keyspace);
        this.metadata = metadata;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getName();
    }

    @Property(viewable=true, editable=true, order=100)
    public String getDescription() {
        return this.metadata.getOptions().getComment();
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.VIEW;
    }

    @Override
    protected List<ColumnMetadata> getMetaColumns() {
        return this.metadata.getColumns();
    }

    public boolean isView() {
        return true;
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    public Collection<CasTableKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        return this.metadata.exportAsString();
    }

    @Property(viewable=false, editable=false, order=10, category="Options")
    public double getBloomFilterFalsePositiveChance() {
        return this.metadata.getOptions().getBloomFilterFalsePositiveChance();
    }

    @Property(viewable=false, editable=false, order=11, category="Options")
    public Map<String, String> getCaching() {
        return this.metadata.getOptions().getCaching();
    }

    @Property(viewable=false, editable=false, order=12, category="Options")
    public Map<String, String> getCompaction() {
        return this.metadata.getOptions().getCompaction();
    }

    @Property(viewable=false, editable=false, order=13, category="Options")
    public Map<String, String> getCompression() {
        return this.metadata.getOptions().getCompression();
    }

    @Property(viewable=false, editable=false, order=14, category="Options")
    public int getDefaultTimeToLive() {
        return this.metadata.getOptions().getDefaultTimeToLive();
    }

    @Property(viewable=false, editable=false, order=15, category="Options")
    public int getGcGraceInSeconds() {
        return this.metadata.getOptions().getGcGraceInSeconds();
    }

    @Property(viewable=false, editable=false, order=16, category="Options")
    public Integer getIndexInterval() {
        return this.metadata.getOptions().getIndexInterval();
    }

    @Property(viewable=false, editable=false, order=17, category="Options")
    public double getLocalReadRepairChance() {
        return this.metadata.getOptions().getLocalReadRepairChance();
    }

    @Property(viewable=false, editable=false, order=18, category="Options")
    public int getMemtableFlushPeriodInMs() {
        return this.metadata.getOptions().getMemtableFlushPeriodInMs();
    }

    @Property(viewable=false, editable=false, order=19, category="Options")
    public boolean getPopulateIOCacheOnFlush() {
        return this.metadata.getOptions().getPopulateIOCacheOnFlush();
    }

    @Property(viewable=false, editable=false, order=20, category="Options")
    public double getReadRepairChance() {
        return this.metadata.getOptions().getReadRepairChance();
    }

    @Property(viewable=false, editable=false, order=21, category="Options")
    public boolean getReplicateOnWrite() {
        return this.metadata.getOptions().getReplicateOnWrite();
    }

    @Property(viewable=false, editable=false, order=22, category="Options")
    public String getSpeculativeRetry() {
        return this.metadata.getOptions().getSpeculativeRetry();
    }

    @Property(viewable=false, editable=false, order=23, category="Options")
    public boolean isCompactStorage() {
        return this.metadata.getOptions().isCompactStorage();
    }
}

