/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.model;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CasDataSourceInfo
implements DBPDataSourceInfo {
    private static final Log log = Log.getLog(CasDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "com.datastax.driver.core";
    private final Metadata metadata;

    public CasDataSourceInfo(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isReadOnlyData() {
        return false;
    }

    public boolean isReadOnlyMetaData() {
        return false;
    }

    public String getDatabaseProductName() {
        return "Cassandra";
    }

    public String getDatabaseProductVersion() {
        String version = "";
        HashSet<String> visitedVersions = new HashSet<String>();
        Set allHosts = this.metadata.getAllHosts();
        for (Host host : allHosts) {
            String hostVersion = host.getCassandraVersion().toString();
            if (visitedVersions.contains(hostVersion)) continue;
            visitedVersions.add(hostVersion);
            if (!version.isEmpty()) {
                version = String.valueOf(version) + ",";
            }
            version = String.valueOf(version) + hostVersion;
        }
        return version;
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Cassandra driver bundle 'com.datastax.driver.core' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        return this.getDriverBundle().getVersion();
    }

    public String getDriverName() {
        return (String)this.getDriverBundle().getHeaders().get("Bundle-Name");
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Keyspace";
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsReferentialIntegrity() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsStoredCode() {
        return false;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public boolean supportsResultSetLimit() {
        return false;
    }

    public boolean supportsResultSetScroll() {
        return false;
    }

    public boolean isDynamicMetadata() {
        return true;
    }

    public boolean supportsMultipleResults() {
        return false;
    }
}

