/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.cassandra.data.handlers;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.dbeaver.ent.cassandra.data.handlers.CasBaseValueHandler;
import com.dbeaver.ent.cassandra.exec.CasPreparedStatement;
import com.dbeaver.ent.cassandra.exec.CasSession;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasNumberValueHandler
extends CasBaseValueHandler {
    private static final Log log = Log.getLog(CasNumberValueHandler.class);
    private DataType.Name typeName;
    private DBDDataFormatter formatter;

    public CasNumberValueHandler(DBSTypedObject typedObject, DataType.Name typeName, DBDDataFormatterProfile formatterProfile) {
        this.typeName = typeName;
        try {
            this.formatter = formatterProfile.createFormatter("number", typedObject);
        }
        catch (Exception e) {
            log.error((Object)"Can't create formatter for number value handler", (Throwable)e);
            this.formatter = DefaultDataFormatter.INSTANCE;
        }
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value == null) {
            return DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)format);
        }
        if (format == DBDDisplayFormat.NATIVE || format == DBDDisplayFormat.EDIT) {
            if (value instanceof Number) {
                return DBValueFormatting.convertNumberToNativeString((Number)((Number)value));
            }
            return value.toString();
        }
        return this.formatter.formatValue(value);
    }

    @NotNull
    public Class<? extends Number> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return this.getNumberType(attribute);
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return object;
        }
        return DBValueFormatting.convertStringToNumber((String)object.toString(), this.getNumberType(type), (DBDDataFormatter)this.formatter);
    }

    public Class<? extends Number> getNumberType(DBSTypedObject type) {
        switch (this.typeName) {
            case SMALLINT: {
                return Short.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case INT: {
                return Integer.class;
            }
            case BIGINT: 
            case COUNTER: {
                return Long.class;
            }
            case VARINT: {
                return BigInteger.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        return Long.class;
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        BoundStatement boundStatement = statement.getBoundStatement();
        if (!(value instanceof Number)) {
            boundStatement.setToNull(paramIndex);
        } else {
            switch (this.typeName) {
                case SMALLINT: {
                    boundStatement.setShort(paramIndex, ((Number)value).shortValue());
                    break;
                }
                case TINYINT: {
                    boundStatement.setByte(paramIndex, ((Number)value).byteValue());
                    break;
                }
                case INT: {
                    boundStatement.setInt(paramIndex, ((Number)value).intValue());
                    break;
                }
                case BIGINT: 
                case COUNTER: {
                    boundStatement.setLong(paramIndex, ((Number)value).longValue());
                    break;
                }
                case VARINT: {
                    boundStatement.setVarint(paramIndex, value instanceof BigInteger ? (BigInteger)value : BigInteger.valueOf(((Number)value).longValue()));
                    break;
                }
                case DECIMAL: {
                    boundStatement.setDecimal(paramIndex, value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf(((Number)value).longValue()));
                    break;
                }
                case FLOAT: {
                    boundStatement.setFloat(paramIndex, ((Number)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    boundStatement.setDouble(paramIndex, ((Number)value).doubleValue());
                    break;
                }
                default: {
                    boundStatement.setLong(paramIndex, ((Number)value).longValue());
                }
            }
        }
    }
}

