/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.mongodb.model;

import com.dbeaver.ent.mongodb.MongoUtils;
import com.dbeaver.ent.mongodb.exec.MongoDeleteStatement;
import com.dbeaver.ent.mongodb.exec.MongoInsertStatement;
import com.dbeaver.ent.mongodb.exec.MongoResultSet;
import com.dbeaver.ent.mongodb.exec.MongoSelectStatement;
import com.dbeaver.ent.mongodb.exec.MongoSession;
import com.dbeaver.ent.mongodb.exec.MongoUpdateStatement;
import com.dbeaver.ent.mongodb.model.MGCollectionAttribute;
import com.dbeaver.ent.mongodb.model.MGDataType;
import com.dbeaver.ent.mongodb.model.MGDatabase;
import com.dbeaver.ent.mongodb.model.MGIndex;
import com.dbeaver.ent.mongodb.model.MongoDataSource;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class MGCollection
implements DBSTable,
DBSDataContainer,
DBSDataManipulator,
DBPSaveableObject,
DBPSystemObject {
    private final MGDatabase database;
    private final String collectionName;
    private final IndexCache indexCache = new IndexCache();
    private List<MGCollectionAttribute> metaAttributes;
    private final DocumentAttribute attrDocument;
    private final IdAttribute attrId;
    private final Stats stats = new Stats();
    private boolean persisted;

    public MGCollection(MGDatabase database, String collectionName, boolean persisted) {
        this.database = database;
        this.collectionName = collectionName;
        this.attrDocument = new DocumentAttribute(this);
        this.attrId = new IdAttribute(this);
        this.persisted = persisted;
    }

    @Property(viewable=true, order=3)
    public MGDatabase getDatabase() {
        return this.database;
    }

    @NotNull
    public DBCollection getCollection() throws DBCException {
        return this.database.getDB().getCollection(this.collectionName);
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.collectionName;
    }

    @Property(viewable=true, editable=true, order=100)
    public String getDescription() {
        return null;
    }

    public MGDatabase getParentObject() {
        return this.database;
    }

    @NotNull
    public MongoDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public Collection<? extends MGCollectionAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.metaAttributes != null) {
            return this.metaAttributes;
        }
        monitor.beginTask("Map collection '" + this.collectionName + "' field names", 2);
        try {
            MapReduceOutput result = this.getCollection().mapReduce("function() { for (var key in this) { var value = this[key];var type; if (value instanceof Array) type = 'array'; else if (value instanceof Date) type = 'date'; else type = typeof this[key]; emit(type + ':' + key, null); } }", "function(key, stuff) { return null; }", null, MapReduceCommand.OutputType.INLINE, null);
            monitor.worked(1);
            this.metaAttributes = new ArrayList<MGCollectionAttribute>();
            this.metaAttributes.add(this.attrId);
            for (DBObject field : result.results()) {
                String fieldInfo = (String)field.get("_id");
                int divPos = fieldInfo.indexOf(58);
                String fieldType = fieldInfo.substring(0, divPos);
                String fieldName = fieldInfo.substring(divPos + 1);
                if (fieldName.equals("_id")) continue;
                MGDataType type = this.getDataSource().getDataTypeByJS(fieldType);
                MetaAttribute attr = new MetaAttribute(this, fieldName, type, this.metaAttributes.size());
                this.metaAttributes.add(attr);
            }
            monitor.worked(1);
            Collections.sort(this.metaAttributes, DBUtils.nameComparator());
            List<MGCollectionAttribute> list = this.metaAttributes;
            return list;
        }
        catch (Exception e) {
            throw new DBException("Can't read field names", (Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    public MGCollectionAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) {
        if (attributeName.equals(this.attrDocument.getName())) {
            return this.attrDocument;
        }
        if (attributeName.equals("_id")) {
            return this.attrId;
        }
        return null;
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getAllObjects(monitor, this);
    }

    public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)this.database)) + "." + DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    public int getSupportedFeatures() {
        return 458757;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags) throws DBCException {
        try {
            DBCStatistics statistics;
            block19: {
                MongoSession mongoSession = (MongoSession)session;
                statistics = new DBCStatistics();
                Throwable throwable = null;
                Object var14_13 = null;
                try (MongoSelectStatement statement = new MongoSelectStatement(mongoSession, this, dataFilter);){
                    statement.setStatementSource(source);
                    statement.setLimit(firstRow, maxRows);
                    statistics.setQueryText(statement.getQueryString());
                    statistics.addStatementsCount();
                    if (!statement.executeStatement()) break block19;
                    MongoResultSet resultSet = statement.openResultSet();
                    try {
                        dataReceiver.fetchStart((DBCSession)mongoSession, (DBCResultSet)resultSet, firstRow, maxRows);
                        while (resultSet.nextRow()) {
                            if (session.getProgressMonitor().isCanceled()) {
                                break;
                            }
                            dataReceiver.fetchRow((DBCSession)mongoSession, (DBCResultSet)resultSet);
                        }
                    }
                    finally {
                        dataReceiver.fetchEnd((DBCSession)mongoSession, (DBCResultSet)resultSet);
                        resultSet.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            DBCStatistics dBCStatistics = statistics;
            return dBCStatistics;
        }
        catch (MongoException e) {
            throw new DBCException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
        finally {
            dataReceiver.close();
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter) throws DBCException {
        try {
            return this.getCollection().count(MongoUtils.makeQueryFromFilter(this.getDataSource(), dataFilter));
        }
        catch (MongoException e) {
            throw new DBCException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        final MongoSession mongoSession = (MongoSession)session;
        return new ExecuteBatchImpl(attributes, null, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, Object[] attributeValues) throws DBCException {
                MongoInsertStatement statement = new MongoInsertStatement(mongoSession, MGCollection.this, this.attributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        DBSAttributeBase[] attributes = (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes);
        final MongoSession mongoSession = (MongoSession)session;
        return new ExecuteBatchImpl(attributes, keysReceiver, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, Object[] attributeValues) throws DBCException {
                MongoUpdateStatement statement = new MongoUpdateStatement(mongoSession, MGCollection.this, updateAttributes, keyAttributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] keyAttributes, final @NotNull DBCExecutionSource source) throws DBCException {
        final MongoSession mongoSession = (MongoSession)session;
        return new ExecuteBatchImpl(keyAttributes, null, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, Object[] attributeValues) throws DBCException {
                MongoDeleteStatement statement = new MongoDeleteStatement(mongoSession, MGCollection.this, keyAttributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
            }
        };
    }

    public String getAttributeName(DBSAttributeBase attribute) {
        return DBUtils.getObjectFullName((DBPNamedObject)attribute, (DBPEvaluationContext)DBPEvaluationContext.DML);
    }

    public String getAttributeValue(DBSAttributeBase attribute, Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Date) {
            String formattedTimestamp;
            try {
                DBDDataFormatter formatter = this.getDataSource().getContainer().getDataFormatterProfile().createFormatter("timestamp", (DBSTypedObject)attribute);
                formattedTimestamp = formatter.formatValue(value);
            }
            catch (Exception e) {
                formattedTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(value);
            }
            return "{ts '" + formattedTimestamp + "'}";
        }
        return "'" + value + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup(category="Stats")
    @LazyProperty(cacheValidator=StatsValidator.class)
    public Stats getStats(DBRProgressMonitor monitor) throws DBCException {
        Stats stats = this.stats;
        synchronized (stats) {
            if (!this.stats.loaded) {
                CommandResult result = this.getCollection().getStats();
                this.stats.count = CommonUtils.toLong((Object)result.get("count"));
                this.stats.size = CommonUtils.toLong((Object)result.get("size"));
                this.stats.avgObjSize = CommonUtils.toLong((Object)result.get("avgObjSize"));
                this.stats.storageSize = CommonUtils.toLong((Object)result.get("storageSize"));
                this.stats.numExtents = CommonUtils.toLong((Object)result.get("numExtents"));
                this.stats.lastExtentSize = CommonUtils.toLong((Object)result.get("lastExtentSize"));
                this.stats.paddingFactor = CommonUtils.toLong((Object)result.get("paddingFactor"));
                this.stats.flags = CommonUtils.toLong((Object)result.get("flags"));
                this.stats.totalIndexSize = CommonUtils.toLong((Object)result.get("totalIndexSize"));
                this.stats.loaded = true;
            }
            return this.stats;
        }
    }

    public boolean isSystem() {
        return this.collectionName.startsWith("system.");
    }

    public MGCollectionAttribute getDocumentAttribute() {
        return this.attrDocument;
    }

    public static class DocumentAttribute
    extends MGCollectionAttribute {
        DocumentAttribute(MGCollection collection) {
            super(collection, "document", 0);
        }

        public String getTypeName() {
            return "json";
        }

        public int getTypeID() {
            return 2;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.DOCUMENT;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }
    }

    public static class IdAttribute
    extends MGCollectionAttribute {
        IdAttribute(MGCollection collection) {
            super(collection, "_id", 0);
        }

        public String getTypeName() {
            return "ObjectId";
        }

        public int getTypeID() {
            return 1;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.ROWID;
        }

        public boolean isRequired() {
            return true;
        }

        public boolean isAutoGenerated() {
            return true;
        }
    }

    class IndexCache
    extends AbstractObjectCache<MGCollection, MGIndex> {
        IndexCache() {
        }

        @NotNull
        public Collection<MGIndex> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGCollection collection) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGIndex> indexes = new ArrayList<MGIndex>();
                for (DBObject indexInfo : MGCollection.this.getCollection().getIndexInfo()) {
                    MGIndex index = new MGIndex(monitor, collection, indexInfo);
                    indexes.add(index);
                }
                this.setCache(indexes);
            }
            return this.getCachedObjects();
        }

        public MGIndex getObject(@NotNull DBRProgressMonitor monitor, @Nullable MGCollection casKeyspace, @NotNull String name) throws DBException {
            return (MGIndex)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    public static class MetaAttribute
    extends MGCollectionAttribute {
        private final MGDataType type;

        MetaAttribute(MGCollection collection, String name, MGDataType type, int position) {
            super(collection, name, position);
            this.type = type;
        }

        @Property(viewable=true, editable=false, order=2)
        public String getTypeName() {
            return this.type.getName();
        }

        public int getTypeID() {
            return this.type.getTypeID();
        }

        public DBPDataKind getDataKind() {
            return this.type.getDataKind();
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }
    }

    public static class Stats {
        private boolean loaded;
        private Long count;
        private long size;
        private long avgObjSize;
        private long storageSize;
        private long numExtents;
        private long lastExtentSize;
        private long paddingFactor;
        private long flags;
        private long totalIndexSize;

        @Property(viewable=true, order=21, category="Stats")
        public Long getCount() {
            return this.count;
        }

        @Property(viewable=true, order=22, category="Stats")
        public long getSize() {
            return this.size;
        }

        @Property(viewable=false, order=23, category="Stats")
        public long getAvgObjSize() {
            return this.avgObjSize;
        }

        @Property(viewable=false, order=24, category="Stats")
        public long getStorageSize() {
            return this.storageSize;
        }

        @Property(viewable=false, order=25, category="Stats")
        public long getNumExtents() {
            return this.numExtents;
        }

        @Property(viewable=false, order=26, category="Stats")
        public long getLastExtentSize() {
            return this.lastExtentSize;
        }

        @Property(viewable=false, order=27, category="Stats")
        public long getPaddingFactor() {
            return this.paddingFactor;
        }

        @Property(viewable=false, order=28, category="Stats")
        public long getFlags() {
            return this.flags;
        }

        @Property(viewable=false, order=29, category="Stats")
        public long getTotalIndexSize() {
            return this.totalIndexSize;
        }
    }

    public static class StatsValidator
    implements IPropertyCacheValidator<MGCollection> {
        public boolean isPropertyCached(MGCollection object, Object propertyId) {
            return object.stats.loaded;
        }
    }
}

