/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.mongodb.exec;

import com.dbeaver.ent.mongodb.MongoUtils;
import com.dbeaver.ent.mongodb.exec.MongoResultSet;
import com.dbeaver.ent.mongodb.exec.MongoSession;
import com.dbeaver.ent.mongodb.model.MGCollection;
import com.dbeaver.ent.mongodb.model.MGCollectionAttribute;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.AttributeMetaDataProxy;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class MongoBaseStatement
implements DBCStatement {
    private static final Log log = Log.getLog(MongoBaseStatement.class);
    protected final MongoSession session;
    protected final String query;
    protected DBCExecutionSource source;
    protected MGCollection collection;
    protected DBCursor result;
    protected List<DBObject> resultList;
    protected WriteResult writeResult;
    protected Throwable executeError;
    protected long offset;
    protected long limit;

    protected MongoBaseStatement(MongoSession session, String query) {
        this.session = session;
        this.query = query;
        QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
    }

    @NotNull
    public MongoSession getSession() {
        return this.session;
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public MongoResultSet openResultSet() throws DBCException {
        if (this.resultList != null) {
            return new MongoResultSet(this, this.resultList);
        }
        if (this.result == null) {
            return null;
        }
        return new MongoResultSet(this, this.result);
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int getUpdateRowCount() {
        return this.writeResult == null ? -1 : this.writeResult.getN();
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
        this.result = null;
        this.resultList = null;
        QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, (long)this.getUpdateRowCount());
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void cancelBlock() throws DBException {
        throw new DBException("Mongo query cancel not implemented");
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBPDataSource)this.session.getDataSource());
    }

    protected void beforeExecute() {
        this.executeError = null;
        QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, (long)this.getUpdateRowCount(), this.executeError);
    }

    protected void startBlock() {
        this.session.getProgressMonitor().startBlock((DBRBlockingObject)this, this.getClass().getSimpleName());
    }

    protected void endBlock() {
        this.session.getProgressMonitor().endBlock();
    }

    @NotNull
    public DBCResultSetMetaData createMetadata() {
        return new DBCResultSetMetaData(){

            public List<DBCAttributeMetaData> getAttributes() {
                ArrayList<DBCAttributeMetaData> attrs = new ArrayList<DBCAttributeMetaData>(1);
                attrs.add((DBCAttributeMetaData)new AttributeMeta(MongoBaseStatement.this.collection.getDocumentAttribute()));
                return attrs;
            }
        };
    }

    @NotNull
    public DBCResultSetMetaData createMetadata(final List<DBObject> list) {
        return new DBCResultSetMetaData(){

            public List<DBCAttributeMetaData> getAttributes() {
                if (list != null) {
                    LinkedHashMap<String, Object> colNames = new LinkedHashMap<String, Object>();
                    for (DBObject row : list) {
                        for (String string : row.keySet()) {
                            colNames.put(string, row.get(string));
                        }
                    }
                    ArrayList<DBCAttributeMetaData> attrs = new ArrayList<DBCAttributeMetaData>(1);
                    int position = 0;
                    for (Map.Entry entry : colNames.entrySet()) {
                        attrs.add(new CustomColumnMeta((String)entry.getKey(), entry.getValue(), position++));
                    }
                    return attrs;
                }
                ArrayList<DBCAttributeMetaData> attrs = new ArrayList<DBCAttributeMetaData>(1);
                attrs.add(new DynamicDocumentAttribute());
                return attrs;
            }
        };
    }

    protected void setExecutionResult(CommandResult commandResult) {
        Object retval = commandResult.get("retval");
        if (retval instanceof DBCursor) {
            this.result = (DBCursor)retval;
        } else {
            this.resultList = new ArrayList<DBObject>(1);
            if (retval == null) {
                this.resultList.add((DBObject)commandResult);
            } else if (retval instanceof Collection) {
                boolean objects = true;
                for (Object obj : (Collection)retval) {
                    if (obj instanceof DBObject) continue;
                    objects = false;
                    break;
                }
                if (objects) {
                    this.resultList.addAll((Collection)retval);
                } else {
                    this.resultList.add((DBObject)retval);
                }
            } else if (retval instanceof DBObject) {
                this.resultList.add((DBObject)retval);
            } else {
                this.resultList.add((DBObject)new BasicDBObject("retval", retval));
            }
        }
    }

    protected void setExecutionResult(WriteResult writeResult) {
        this.writeResult = writeResult;
    }

    public abstract class AbstractDocumentAttribute
    implements DBCAttributeMetaData {
        public String getFullTypeName() {
            return this.getTypeName();
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public boolean isReadOnly() {
            return true;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return null;
        }
    }

    private class AttributeMeta
    extends AttributeMetaDataProxy {
        private AttributeMeta(MGCollectionAttribute attribute) {
            super((DBSAttributeBase)attribute);
        }

        public DBSObject getSource() {
            return MongoBaseStatement.this.collection;
        }

        public String getEntityName() {
            return MongoBaseStatement.this.collection.getName();
        }
    }

    private class CustomColumnMeta
    extends AbstractDocumentAttribute {
        private final String name;
        private final Object value;
        private final int position;

        private CustomColumnMeta(String name, Object value, int position) {
            this.name = name;
            this.value = value;
            this.position = position;
        }

        public DBSObject getSource() {
            return MongoBaseStatement.this.collection == null ? MongoBaseStatement.this.getSession().getDataSource().getDefaultObject() : MongoBaseStatement.this.collection;
        }

        @NotNull
        public String getLabel() {
            return this.name;
        }

        public String getEntityName() {
            return MongoBaseStatement.this.collection == null ? null : MongoBaseStatement.this.collection.getName();
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return MongoBaseStatement.this.session.getDataSource().getDataType(this.getTypeID()).getName();
        }

        public int getTypeID() {
            return MongoUtils.resolveValueType(this.value);
        }

        public DBPDataKind getDataKind() {
            return MongoBaseStatement.this.session.getDataSource().resolveDataKind(null, this.getTypeID());
        }
    }

    public class DynamicDocumentAttribute
    extends AbstractDocumentAttribute {
        public String getName() {
            return "document";
        }

        public String getTypeName() {
            return "json";
        }

        public int getTypeID() {
            return 2;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.DOCUMENT;
        }

        public int getOrdinalPosition() {
            return 0;
        }

        public Object getSource() {
            return MongoBaseStatement.this;
        }

        public String getLabel() {
            return "document";
        }

        public String getEntityName() {
            return null;
        }
    }
}

