/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ent.mongodb.data.handlers;

import com.dbeaver.ent.mongodb.data.MongoListValue;
import com.dbeaver.ent.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.ent.mongodb.exec.MongoCustomStatement;
import com.dbeaver.ent.mongodb.exec.MongoSession;
import com.dbeaver.ent.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoListValueHandler
extends MongoBaseValueHandler
implements DBDValueHandlerComposite {
    public static final MongoListValueHandler INSTANCE = new MongoListValueHandler();

    @NotNull
    public Class<List> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return List.class;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        MongoDataSource dataSource = (MongoDataSource)session.getDataSource();
        if (object == null) {
            return new MongoListValue(dataSource, null);
        }
        if (object instanceof MongoListValue) {
            return copy ? ((MongoListValue)object).cloneValue(session.getProgressMonitor()) : object;
        }
        if (object instanceof BasicDBList) {
            return new MongoListValue(dataSource, (BasicDBList)object);
        }
        throw new DBCException("Unsupported mongo collection type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(MongoSession session, MongoCustomStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
    }
}

