/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.tools.SearchListenerAdapter;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEnumeratorListener
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private ISolverService solverService;
    private int nbsolutions = 0;
    private final SolutionFoundListener sfl;

    public SearchEnumeratorListener(SolutionFoundListener sfl) {
        this.sfl = sfl;
    }

    @Override
    public void init(ISolverService solverService) {
        this.solverService = solverService;
    }

    @Override
    public void solutionFound(int[] model, RandomAccessModel lazyModel) {
        int[] clause = new int[model.length];
        int i = 0;
        while (i < model.length) {
            clause[i] = -model[i];
            ++i;
        }
        this.solverService.addClauseOnTheFly(clause);
        ++this.nbsolutions;
        this.sfl.onSolutionFound(model);
    }

    @Override
    public void end(Lbool result) {
        assert (result != Lbool.TRUE);
    }

    public int getNumberOfSolutionFound() {
        return this.nbsolutions;
    }
}

