/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.process;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessController;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ShellProcessView
extends ViewPart
implements DBRProcessController {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.shellProcess";
    private StyledText processLogText;
    private static int viewId = 0;
    private DBRProcessDescriptor processDescriptor;

    public void createPartControl(Composite parent) {
        Composite group = UIUtils.createPlaceholder(parent, 1);
        group.setLayout((Layout)new FillLayout());
        this.processLogText = new StyledText(group, 778);
        UIUtils.setHelp((Control)group, "view-query-manager");
    }

    public DBRProcessDescriptor getProcessDescriptor() {
        return this.processDescriptor;
    }

    public void terminateProcess() {
        if (this.processDescriptor != null && this.processDescriptor.isRunning()) {
            this.processDescriptor.terminate();
            DBeaverUI.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ShellProcessView.this.setPartName(String.valueOf(ShellProcessView.this.processDescriptor.getName()) + " (destroyed: " + ShellProcessView.this.processDescriptor.getExitValue() + ")");
                }
            });
        }
    }

    public void dispose() {
        this.terminateProcess();
        super.dispose();
    }

    public void setFocus() {
        if (this.processLogText != null && !this.processLogText.isDisposed()) {
            this.processLogText.setFocus();
        }
    }

    public static synchronized String getNextId() {
        return String.valueOf(++viewId);
    }

    public void initProcess(DBRProcessDescriptor processDescriptor) {
        this.processDescriptor = processDescriptor;
        this.setPartName(processDescriptor.getName());
        new ProcessLogger().schedule();
    }

    private void writeProcessLog(String line) {
        if (line.isEmpty()) {
            return;
        }
        final String logLine = String.valueOf(line) + GeneralUtils.getDefaultLineSeparator();
        DBeaverUI.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ShellProcessView.this.processLogText == null || ShellProcessView.this.processLogText.isDisposed()) {
                    return;
                }
                ShellProcessView.this.processLogText.append(logLine);
            }
        });
    }

    private class ProcessLogger
    extends AbstractJob {
        protected ProcessLogger() {
            super(ShellProcessView.this.processDescriptor.getName());
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                Process process = ShellProcessView.this.processDescriptor.getProcess();
                if (process == null) {
                    return Status.OK_STATUS;
                }
                try {
                    String line;
                    InputStream execOut = process.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(execOut, GeneralUtils.getDefaultConsoleEncoding()));
                    while ((line = reader.readLine()) != null) {
                        ShellProcessView.this.writeProcessLog(line);
                    }
                }
                finally {
                    ShellProcessView.this.processDescriptor.terminate();
                }
            }
            catch (Exception e) {
                return GeneralUtils.makeExceptionStatus((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

