/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.bookmarks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.dbeaver.ui.resources.ResourceUtils;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarkStorage;
import org.jkiss.dbeaver.ui.resources.bookmarks.DBNBookmark;
import org.jkiss.dbeaver.ui.resources.bookmarks.DBNBookmarkFolder;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class BookmarksHandlerImpl
extends AbstractResourceHandler {
    private static final String BOOKMARK_EXT = "bm";

    public static IFolder getBookmarksFolder(IProject project, boolean forceCreate) {
        return DBeaverCore.getInstance().getProjectRegistry().getResourceDefaultRoot(project, BookmarksHandlerImpl.class, forceCreate);
    }

    @Override
    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        return super.getFeatures(resource);
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "bookmark folder";
        }
        return "bookmark";
    }

    @Override
    @NotNull
    public String getResourceNodeName(@NotNull IResource resource) {
        if (resource.getParent() instanceof IProject) {
            return "Bookmarks";
        }
        return super.getResourceNodeName(resource);
    }

    @Override
    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof IFile) {
            return new DBNBookmark(parentNode, resource, this);
        }
        return new DBNBookmarkFolder(parentNode, resource, this);
    }

    @Override
    public void openResource(final @NotNull IResource resource) throws CoreException, DBException {
        if (!(resource instanceof IFile)) {
            return;
        }
        DBNProject projectNode = DBeaverCore.getInstance().getNavigatorModel().getRoot().getProject(resource.getProject());
        if (projectNode == null) {
            throw new DBException("Can't find project node for '" + resource.getProject().getName() + "'");
        }
        final BookmarkStorage storage = new BookmarkStorage((IFile)resource, false);
        try {
            DBPDataSourceContainer dataSourceContainer = projectNode.getDatabases().getDataSourceRegistry().getDataSource(storage.getDataSourceId());
            if (dataSourceContainer == null) {
                throw new DBException("Can't find datasource '" + storage.getDataSourceId() + "'");
            }
            final DBNDataSource dsNode = (DBNDataSource)NavigatorUtils.getNodeByObject((DBSObject)dataSourceContainer);
            if (dsNode == null) {
                throw new DBException("Can't find datasource node for '" + dataSourceContainer.getName() + "'");
            }
            dsNode.initializeNode(null, new DBRProgressListener(){

                public void onTaskFinished(IStatus status) {
                    if (status.isOK()) {
                        DBeaverUI.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                BookmarksHandlerImpl.this.openNodeByPath(dsNode, (IFile)resource, storage);
                            }
                        });
                    } else {
                        DBUserInterface.getInstance().showError("Open bookmark", "Can't open bookmark", status);
                    }
                }
            });
        }
        finally {
            storage.dispose();
        }
    }

    private void openNodeByPath(final DBNDataSource dsNode, final IFile file, final BookmarkStorage storage) {
        try {
            DBeaverUI.runInProgressService(new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block9: {
                        try {
                            DBNDataSource currentNode = dsNode;
                            Collection<String> dataSourcePath = storage.getDataSourcePath();
                            for (String path : dataSourcePath) {
                                Object nextChild = null;
                                Object[] children = currentNode.getChildren(monitor);
                                if (!ArrayUtils.isEmpty((Object[])children)) {
                                    Object[] objectArray = children;
                                    int n = children.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Object node = objectArray[n2];
                                        if (path.equals(node.getNodeName())) {
                                            nextChild = node;
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                                if (nextChild == null) {
                                    throw new DBException("Can't find node '" + path + "' in '" + currentNode.getNodeFullName() + "'");
                                }
                                currentNode = nextChild;
                            }
                            if (currentNode instanceof DBNDatabaseNode) {
                                storage.setImage(currentNode.getNodeIconDefault());
                                file.setContents((InputStream)storage.serialize(), true, false, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                                final DBNDatabaseNode databaseNode = (DBNDatabaseNode)currentNode;
                                DBeaverUI.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)databaseNode, null, DBeaverUI.getActiveWorkbenchWindow());
                                    }
                                });
                                break block9;
                            }
                            if (currentNode != null) {
                                throw new DBException("Node '" + currentNode.getNodeFullName() + "' is not a database object");
                            }
                            throw new DBException("Can't find database node by path");
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBUserInterface.getInstance().showError(CoreMessages.model_project_open_bookmark, CoreMessages.model_project_cant_open_bookmark, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void createBookmark(DBNDatabaseNode node, String title, IFolder folder) throws DBException {
        IProject project;
        if (folder == null && (project = node.getOwnerProject()) != null) {
            folder = BookmarksHandlerImpl.getBookmarksFolder(project, true);
        }
        if (folder == null) {
            throw new DBException("Can't detect folder for bookmark");
        }
        ResourceUtils.checkFolderExists(folder);
        IFile file = ContentUtils.getUniqueFile((IFolder)folder, (String)CommonUtils.escapeFileName((String)title), (String)BOOKMARK_EXT);
        BookmarksHandlerImpl.updateBookmark(node, title, file);
    }

    private static void updateBookmark(DBNDatabaseNode node, String title, IFile file) throws DBException {
        if (CommonUtils.isEmpty((String)title)) {
            title = node.getNodeName();
        }
        ArrayList<String> nodePath = new ArrayList<String>();
        DBNDatabaseNode parent = node;
        while (!(parent instanceof DBNDataSource)) {
            nodePath.add(0, parent.getNodeName());
            parent = parent.getParentNode();
        }
        String dsId = null;
        if (node.getObject() != null && node.getObject().getDataSource() != null) {
            dsId = node.getObject().getDataSource().getContainer().getId();
        }
        BookmarkStorage storage = new BookmarkStorage(title, String.valueOf(node.getNodeType()) + " " + node.getNodeName(), node.getNodeIconDefault(), dsId, nodePath);
        try {
            ByteArrayInputStream data = storage.serialize();
            file.create((InputStream)data, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            throw new DBException("Error saving bookmark", (Throwable)e);
        }
    }
}

