/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.SelectDataSourceDialog;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public abstract class TargetPrefPage
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    static final Log log = Log.getLog(TargetPrefPage.class);
    private DBNDataSource containerNode;
    private Button dataSourceSettingsButton;
    private Control configurationBlockControl;
    private Link changeSettingsTargetLink;
    private ControlEnableState blockEnableState;

    protected TargetPrefPage() {
    }

    public final boolean isDataSourcePreferencePage() {
        return this.containerNode != null;
    }

    protected abstract boolean hasDataSourceSpecificOptions(DBPDataSourceContainer var1);

    protected abstract boolean supportsDataSourceSpecificOptions();

    protected void createPreferenceHeader(Composite composite) {
    }

    protected abstract Control createPreferenceContent(Composite var1);

    protected abstract void loadPreferences(DBPPreferenceStore var1);

    protected abstract void savePreferences(DBPPreferenceStore var1);

    protected abstract void clearPreferences(DBPPreferenceStore var1);

    protected abstract String getPropertyPageID();

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.containerNode == null ? null : this.containerNode.getObject();
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.containerNode;
    }

    public void setElement(IAdaptable element) {
        if (element == null) {
            return;
        }
        this.containerNode = (DBNDataSource)element.getAdapter(DBNDataSource.class);
        if (this.containerNode == null) {
            DBPDataSourceContainer dsContainer = (DBPDataSourceContainer)element.getAdapter(DBPDataSourceContainer.class);
            if (dsContainer != null) {
                this.containerNode = (DBNDataSource)DBeaverCore.getInstance().getNavigatorModel().findNode((DBSObject)dsContainer);
            } else {
                IDatabaseEditorInput dbInput = (IDatabaseEditorInput)element.getAdapter(IDatabaseEditorInput.class);
                if (dbInput != null) {
                    DBNDatabaseNode dbNode = dbInput.getNavigatorNode();
                    if (dbNode instanceof DBNDataSource) {
                        this.containerNode = (DBNDataSource)dbNode;
                    }
                } else if (element instanceof DBPContextProvider) {
                    DBCExecutionContext context = ((DBPContextProvider)element).getExecutionContext();
                    if (context != null) {
                        this.containerNode = (DBNDataSource)DBeaverCore.getInstance().getNavigatorModel().findNode((DBSObject)context.getDataSource().getContainer());
                    }
                } else if (element instanceof DBPDataSourceContainer) {
                    this.containerNode = (DBNDataSource)DBeaverCore.getInstance().getNavigatorModel().findNode((DBSObject)((DBPDataSourceContainer)element));
                }
            }
        }
    }

    public void applyData(Object data) {
        if (this.containerNode == null && data instanceof IAdaptable) {
            this.setElement((IAdaptable)data);
        }
    }

    protected Label createDescriptionLabel(Composite parent) {
        if (this.isDataSourcePreferencePage()) {
            Composite composite = UIUtils.createPlaceholder(parent, 2);
            composite.setFont(parent.getFont());
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.dataSourceSettingsButton = new Button(composite, 32);
            this.dataSourceSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = TargetPrefPage.this.dataSourceSettingsButton.getSelection();
                    TargetPrefPage.this.enableDataSourceSpecificSettings(enabled);
                }
            });
            String dataSourceName = this.containerNode.getDataSourceContainer().getName();
            this.dataSourceSettingsButton.setText(NLS.bind((String)CoreMessages.pref_page_target_button_use_datasource_settings, (Object)dataSourceName));
            GridData gd = new GridData(768);
            this.dataSourceSettingsButton.setLayoutData((Object)gd);
            this.changeSettingsTargetLink = this.createLink(composite, CoreMessages.pref_page_target_link_show_global_settings);
            this.changeSettingsTargetLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        } else if (this.supportsDataSourceSpecificOptions()) {
            this.changeSettingsTargetLink = this.createLink(parent, CoreMessages.pref_page_target_link_show_datasource_settings);
            this.changeSettingsTargetLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        Label horizontalLine = new Label(parent, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        horizontalLine.setFont(parent.getFont());
        this.createPreferenceHeader(parent);
        return super.createDescriptionLabel(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 1);
        this.configurationBlockControl = this.createPreferenceContent(composite);
        this.configurationBlockControl.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.isDataSourcePreferencePage()) {
            boolean useProjectSettings = this.hasDataSourceSpecificOptions(this.getDataSourceContainer());
            this.enableDataSourceSpecificSettings(useProjectSettings);
        }
        DBPPreferenceStore store = this.useDataSourceSettings() ? this.getDataSourceContainer().getPreferenceStore() : DBeaverCore.getGlobalPreferenceStore();
        this.loadPreferences(store);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Link createLink(Composite composite, String text) {
        Link link = UIUtils.createLink(composite, "<A>" + text + "</A>", new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TargetPrefPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        link.setFont(composite.getFont());
        return link;
    }

    protected void enableDataSourceSpecificSettings(boolean useProjectSpecificSettings) {
        this.dataSourceSettingsButton.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
        this.doStatusChanged();
    }

    protected void doStatusChanged() {
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else if (this.blockEnableState == null) {
            this.blockEnableState = ControlEnableState.disable((Control)this.configurationBlockControl);
        }
    }

    protected boolean useDataSourceSettings() {
        return this.isDataSourcePreferencePage() && this.dataSourceSettingsButton != null && this.dataSourceSettingsButton.getSelection();
    }

    private void updateLinkVisibility() {
        if (this.changeSettingsTargetLink == null || this.changeSettingsTargetLink.isDisposed()) {
            return;
        }
        if (this.isDataSourcePreferencePage()) {
            this.changeSettingsTargetLink.setEnabled(true);
        }
    }

    private void doLinkActivated(Link link) {
        DBNDatabaseNode dsNode;
        DBPDataSourceContainer dataSource;
        SelectDataSourceDialog dialog;
        PreferenceDialog prefDialog = null;
        if (this.isDataSourcePreferencePage()) {
            prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)this.getPropertyPageID(), null, null);
        } else if (this.supportsDataSourceSpecificOptions() && (dialog = new SelectDataSourceDialog(this.getShell(), null, null)).open() != 1 && (dataSource = dialog.getDataSource()) != null && (dsNode = NavigatorUtils.getNodeByObject((DBSObject)dataSource)) instanceof DBNDataSource) {
            prefDialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)dsNode, (String)this.getPropertyPageID(), null, null);
        }
        if (prefDialog != null) {
            prefDialog.open();
        }
    }

    protected void performApply() {
        this.performOk();
    }

    public final boolean performOk() {
        DBPPreferenceStore store;
        DBPPreferenceStore dBPPreferenceStore = store = this.isDataSourcePreferencePage() ? this.getDataSourceContainer().getPreferenceStore() : DBeaverCore.getGlobalPreferenceStore();
        if (this.isDataSourcePreferencePage() && !this.useDataSourceSettings()) {
            this.clearPreferences(store);
            PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        } else {
            this.savePreferences(store);
        }
        return super.performOk();
    }
}

