/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLCompletion
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.completion";
    private Button csAutoActivationCheck;
    private Spinner csAutoActivationDelaySpinner;
    private Button csAutoActivateOnKeystroke;
    private Button csAutoInsertCheck;
    private Combo csInsertCase;
    private Button csHideDuplicates;
    private Button csShortName;
    private Button csLongName;
    private Button csInsertSpace;
    private Button csUseGlobalSearch;
    private Button csFoldingEnabled;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("SQLEditor.ContentAssistant.auto.activation.enable") || store.contains("SQLEditor.ContentAssistant.auto.activation.delay") || store.contains("SQLEditor.ContentAssistant.auto.keystrokes.activation") || store.contains("SQLEditor.ContentAssistant.insert.single.proposal") || store.contains("SQLEditor.ContentAssistant.insert.case") || store.contains("SQLEditor.ContentAssistant.hide.duplicates") || store.contains("SQLEditor.ContentAssistant.proposals.short.name") || store.contains("SQLEditor.ContentAssistant.proposals.long.name") || store.contains("SQLEditor.ContentAssistant.insert.space.after.proposal") || store.contains("SQLEditor.ContentAssistant.use.global.search") || store.contains("SQLEditor.Folding.enabled");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 1);
        Group assistGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_completion_group_sql_assistant, 2, 768, 0);
        this.csAutoActivationCheck = UIUtils.createCheckbox((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_enable_auto_activation, CoreMessages.pref_page_sql_completion_label_enable_auto_activation_tip, false, 2);
        UIUtils.createControlLabel((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_auto_activation_delay);
        this.csAutoActivationDelaySpinner = new Spinner((Composite)assistGroup, 2048);
        this.csAutoActivationDelaySpinner.setSelection(0);
        this.csAutoActivationDelaySpinner.setDigits(0);
        this.csAutoActivationDelaySpinner.setIncrement(50);
        this.csAutoActivationDelaySpinner.setMinimum(0);
        this.csAutoActivationDelaySpinner.setMaximum(1000000);
        this.csAutoActivationDelaySpinner.setToolTipText(CoreMessages.pref_page_sql_completion_label_set_auto_activation_delay_tip);
        this.csAutoActivateOnKeystroke = UIUtils.createCheckbox((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_activate_on_typing, CoreMessages.pref_page_sql_completion_label_activate_on_typing_tip, false, 2);
        this.csAutoInsertCheck = UIUtils.createCheckbox((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_auto_insert_proposal, CoreMessages.pref_page_sql_completion_label_auto_insert_proposal_tip, false, 2);
        UIUtils.createControlLabel((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_insert_case);
        this.csInsertCase = new Combo((Composite)assistGroup, 2060);
        this.csInsertCase.add("Default");
        this.csInsertCase.add("Upper case");
        this.csInsertCase.add("Lower case");
        this.csHideDuplicates = UIUtils.createCheckbox((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_hide_duplicate_names, null, false, 2);
        this.csShortName = UIUtils.createCheckbox((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_use_short_names, null, false, 2);
        this.csLongName = UIUtils.createCheckbox((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_use_long_names, null, false, 2);
        this.csInsertSpace = UIUtils.createCheckbox((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_insert_space, null, false, 2);
        this.csUseGlobalSearch = UIUtils.createCheckbox((Composite)assistGroup, CoreMessages.pref_page_sql_completion_label_use_global_search, CoreMessages.pref_page_sql_completion_label_use_global_search_tip, false, 2);
        Group foldingGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_completion_group_folding, 2, 768, 0);
        this.csFoldingEnabled = UIUtils.createCheckbox((Composite)foldingGroup, CoreMessages.pref_page_sql_completion_label_folding_enabled, CoreMessages.pref_page_sql_completion_label_folding_enabled_tip, false, 2);
        return composite;
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.csAutoActivationCheck.setSelection(store.getBoolean("SQLEditor.ContentAssistant.auto.activation.enable"));
            this.csAutoActivationDelaySpinner.setSelection(store.getInt("SQLEditor.ContentAssistant.auto.activation.delay"));
            this.csAutoActivateOnKeystroke.setSelection(store.getBoolean("SQLEditor.ContentAssistant.auto.keystrokes.activation"));
            this.csAutoInsertCheck.setSelection(store.getBoolean("SQLEditor.ContentAssistant.insert.single.proposal"));
            this.csInsertCase.select(store.getInt("SQLEditor.ContentAssistant.insert.case"));
            this.csHideDuplicates.setSelection(store.getBoolean("SQLEditor.ContentAssistant.hide.duplicates"));
            this.csShortName.setSelection(store.getBoolean("SQLEditor.ContentAssistant.proposals.short.name"));
            this.csLongName.setSelection(store.getBoolean("SQLEditor.ContentAssistant.proposals.long.name"));
            this.csInsertSpace.setSelection(store.getBoolean("SQLEditor.ContentAssistant.insert.space.after.proposal"));
            this.csUseGlobalSearch.setSelection(store.getBoolean("SQLEditor.ContentAssistant.use.global.search"));
            this.csFoldingEnabled.setSelection(store.getBoolean("SQLEditor.Folding.enabled"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("SQLEditor.ContentAssistant.auto.activation.enable", this.csAutoActivationCheck.getSelection());
            store.setValue("SQLEditor.ContentAssistant.auto.activation.delay", this.csAutoActivationDelaySpinner.getSelection());
            store.setValue("SQLEditor.ContentAssistant.auto.keystrokes.activation", this.csAutoActivateOnKeystroke.getSelection());
            store.setValue("SQLEditor.ContentAssistant.insert.single.proposal", this.csAutoInsertCheck.getSelection());
            store.setValue("SQLEditor.ContentAssistant.insert.case", this.csInsertCase.getSelectionIndex());
            store.setValue("SQLEditor.ContentAssistant.hide.duplicates", this.csHideDuplicates.getSelection());
            store.setValue("SQLEditor.ContentAssistant.proposals.short.name", this.csShortName.getSelection());
            store.setValue("SQLEditor.ContentAssistant.proposals.long.name", this.csLongName.getSelection());
            store.setValue("SQLEditor.ContentAssistant.insert.space.after.proposal", this.csInsertSpace.getSelection());
            store.setValue("SQLEditor.ContentAssistant.use.global.search", this.csUseGlobalSearch.getSelection());
            store.setValue("SQLEditor.Folding.enabled", this.csFoldingEnabled.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("SQLEditor.ContentAssistant.auto.activation.enable");
        store.setToDefault("SQLEditor.ContentAssistant.auto.activation.delay");
        store.setToDefault("SQLEditor.ContentAssistant.auto.keystrokes.activation");
        store.setToDefault("SQLEditor.ContentAssistant.insert.single.proposal");
        store.setToDefault("SQLEditor.ContentAssistant.insert.case");
        store.setToDefault("SQLEditor.ContentAssistant.hide.duplicates");
        store.setToDefault("SQLEditor.ContentAssistant.proposals.short.name");
        store.setToDefault("SQLEditor.ContentAssistant.proposals.long.name");
        store.setToDefault("SQLEditor.ContentAssistant.insert.space.after.proposal");
        store.setToDefault("SQLEditor.ContentAssistant.use.global.search");
        store.setToDefault("SQLEditor.Folding.enabled");
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

