/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database.load;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;

public class TreeLoadNode
implements ILabelProvider {
    private static final Map<Object, Object> loadingFiles = new HashMap<Object, Object>();
    private static final Map<Object, Object> placeHolders = new HashMap<Object, Object>();
    public static final Object LOADING_FAMILY = new Object();
    private DBNNode parent;
    private String text;
    private String text1;
    private String text2;
    private String text3;
    private int count = 0;
    private boolean disposed = false;
    private Image imgLoading1;
    private Image imgLoading2;
    private Image imgLoading3;
    private Image imgLoading4;

    public static synchronized TreeLoadNode createPlaceHolder(DBNNode parent) {
        TreeLoadNode node = null;
        if (!placeHolders.containsKey(parent)) {
            node = new TreeLoadNode(parent);
            placeHolders.put(parent, node);
        }
        return node;
    }

    private TreeLoadNode(DBNNode parent) {
        this.parent = parent;
        this.text = "Loading";
        this.text1 = String.valueOf(this.text) + ".";
        this.text2 = String.valueOf(this.text) + "..";
        this.text3 = String.valueOf(this.text) + "...";
        this.imgLoading1 = DBeaverIcons.getImage((DBPImage)UIIcon.LOADING1);
        this.imgLoading2 = DBeaverIcons.getImage((DBPImage)UIIcon.LOADING2);
        this.imgLoading3 = DBeaverIcons.getImage((DBPImage)UIIcon.LOADING3);
        this.imgLoading4 = DBeaverIcons.getImage((DBPImage)UIIcon.LOADING4);
    }

    public DBNNode getParent() {
        return this.parent;
    }

    public String getText(Object element) {
        switch (this.count % 4) {
            case 0: {
                return this.text;
            }
            case 1: {
                return this.text1;
            }
            case 2: {
                return this.text2;
            }
        }
        return this.text3;
    }

    public Image getImage(Object element) {
        ++this.count;
        switch (this.count %= 4) {
            case 0: {
                return this.imgLoading1;
            }
            case 1: {
                return this.imgLoading2;
            }
            case 2: {
                return this.imgLoading3;
            }
        }
        return this.imgLoading4;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose(Object parent) {
        this.disposed = true;
        loadingFiles.remove(parent);
        placeHolders.remove(parent);
    }

    public static synchronized boolean canBeginLoading(Object parent) {
        if (!loadingFiles.containsKey(parent)) {
            loadingFiles.put(parent, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoading() {
        Map<Object, Object> map = loadingFiles;
        synchronized (map) {
            return !loadingFiles.isEmpty();
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

