/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.editors.MultiPageAbstractEditor;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;

public class NavigatorPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.navigator";
    public static final String PROP_ACTIVE = "active";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        INavigatorModelView nmv = NavigatorPropertyTester.getActiveNavigator((IWorkbenchPart)receiver);
        return nmv != null && this.checkNavigatorProperty(nmv, property, expectedValue);
    }

    private boolean checkNavigatorProperty(INavigatorModelView rsv, String property, Object expectedValue) {
        return PROP_ACTIVE.equals(property);
    }

    public static INavigatorModelView getActiveNavigator(IWorkbenchPart activePart) {
        if (activePart == null) {
            return null;
        }
        if (activePart instanceof INavigatorModelView) {
            return (INavigatorModelView)activePart;
        }
        if (activePart instanceof MultiPageAbstractEditor) {
            return NavigatorPropertyTester.getActiveNavigator((IWorkbenchPart)((MultiPageAbstractEditor)activePart).getActiveEditor());
        }
        if (activePart instanceof ITabbedFolderContainer) {
            ITabbedFolder activeFolder = ((ITabbedFolderContainer)activePart).getActiveFolder();
            if (activeFolder instanceof INavigatorModelView) {
                return (INavigatorModelView)((Object)activeFolder);
            }
            if (activeFolder instanceof IWorkbenchPart) {
                return NavigatorPropertyTester.getActiveNavigator((IWorkbenchPart)activeFolder);
            }
        }
        return (INavigatorModelView)activePart.getAdapter(INavigatorModelView.class);
    }
}

