/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.registry.sql.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.registry.sql.SQLCommandsRegistry;
import org.jkiss.dbeaver.runtime.sql.SQLRuleProvider;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLScriptPosition;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLWordDetector;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLWordRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.LineCommentRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLDelimiterSetRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLParameterRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLVariableRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLBlockBeginToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLBlockEndToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLBlockHeaderToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLBlockToggleToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLCommentToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLControlToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLDelimiterToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLParameterToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLSetDelimiterToken;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLVariableToken;
import org.jkiss.dbeaver.ui.editors.text.TextWhiteSpaceDetector;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class SQLRuleManager
extends RuleBasedScanner {
    private static final long MAX_FILE_LENGTH_FOR_RULES = 5000000L;
    @NotNull
    private final IThemeManager themeManager;
    @NotNull
    private SQLSyntaxManager syntaxManager;
    @NotNull
    private TreeMap<Integer, SQLScriptPosition> positions = new TreeMap();
    private Set<SQLScriptPosition> addedPositions = new HashSet<SQLScriptPosition>();
    private Set<SQLScriptPosition> removedPositions = new HashSet<SQLScriptPosition>();
    private boolean evalMode;

    public SQLRuleManager(@NotNull SQLSyntaxManager syntaxManager) {
        this.syntaxManager = syntaxManager;
        this.themeManager = PlatformUI.getWorkbench().getThemeManager();
    }

    public boolean isEvalMode() {
        return this.evalMode;
    }

    public void startEval() {
        this.evalMode = true;
    }

    public void endEval() {
        this.evalMode = false;
        if (this.fRules != null) {
            IRule[] iRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                IRule rule = iRuleArray[n2];
                if (rule instanceof SQLDelimiterRule) {
                    ((SQLDelimiterRule)rule).changeDelimiter(null);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
    }

    @NotNull
    public Collection<? extends Position> getPositions(int offset, int length) {
        return this.positions.subMap(offset, offset + length).values();
    }

    @NotNull
    public synchronized Set<SQLScriptPosition> getRemovedPositions(boolean clear) {
        Set<SQLScriptPosition> posList = this.removedPositions;
        if (clear) {
            this.removedPositions = new HashSet<SQLScriptPosition>();
        }
        return posList;
    }

    @NotNull
    public synchronized Set<SQLScriptPosition> getAddedPositions(boolean clear) {
        Set<SQLScriptPosition> posList = this.addedPositions;
        if (clear) {
            this.addedPositions = new HashSet<SQLScriptPosition>();
        }
        return posList;
    }

    public void refreshRules(@Nullable DBPDataSource dataSource, IEditorInput editorInput) {
        String blockToggleString;
        Pair multiLineComments;
        SQLDialect dialect = this.syntaxManager.getDialect();
        SQLRuleProvider ruleProvider = null;
        if (dialect instanceof SQLRuleProvider) {
            ruleProvider = (SQLRuleProvider)dialect;
        }
        boolean minimalRules = false;
        File file = EditorUtils.getLocalFileFromInput(editorInput);
        if (file != null && file.length() > 5000000L) {
            minimalRules = true;
        }
        Token keywordToken = new Token((Object)new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.keyword.foreground"), null, 1));
        Token typeToken = new Token((Object)new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.datatype.foreground"), null, 1));
        Token stringToken = new Token((Object)new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.string.foreground"), null, 0));
        Token quotedToken = new Token((Object)new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.datatype.foreground"), null, 0));
        Token numberToken = new Token((Object)new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.number.foreground"), null, 0));
        SQLCommentToken commentToken = new SQLCommentToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.comment.foreground"), null, 0));
        SQLDelimiterToken delimiterToken = new SQLDelimiterToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.delimiter.foreground", 3), null, 0));
        SQLParameterToken parameterToken = new SQLParameterToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.parameter.foreground", 10), null, 1));
        SQLVariableToken variableToken = new SQLVariableToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.parameter.foreground", 10), null, 1));
        Token otherToken = new Token((Object)new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.text.foreground"), null, 0));
        SQLBlockHeaderToken blockHeaderToken = new SQLBlockHeaderToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.keyword.foreground"), null, 1));
        SQLBlockBeginToken blockBeginToken = new SQLBlockBeginToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.keyword.foreground"), null, 1));
        SQLBlockEndToken blockEndToken = new SQLBlockEndToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.keyword.foreground"), null, 1));
        SQLBlockToggleToken blockToggleToken = new SQLBlockToggleToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.delimiter.foreground"), null, 1));
        this.setDefaultReturnToken((IToken)otherToken);
        ArrayList<IRule> rules = new ArrayList<IRule>();
        if (ruleProvider != null) {
            ruleProvider.extendRules(rules, SQLRuleProvider.RulePosition.INITIAL);
        }
        String[] stringArray = dialect.getSingleLineComments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lineComment = stringArray[n2];
            if (lineComment.startsWith("^")) {
                rules.add((IRule)new LineCommentRule(lineComment, (IToken)commentToken));
            } else {
                rules.add((IRule)new EndOfLineRule(lineComment, (IToken)commentToken));
            }
            ++n2;
        }
        SQLControlToken controlToken = new SQLControlToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.command.foreground"), null, 1));
        if (ruleProvider != null) {
            ruleProvider.extendRules(rules, SQLRuleProvider.RulePosition.CONTROL);
        }
        String commandPrefix = this.syntaxManager.getControlCommandPrefix();
        for (SQLCommandHandlerDescriptor controlCommand : SQLCommandsRegistry.getInstance().getCommandHandlers()) {
            rules.add((IRule)new EndOfLineRule(String.valueOf(commandPrefix) + controlCommand.getId(), (IToken)controlToken));
        }
        if (!minimalRules && this.syntaxManager.isVariablesEnabled()) {
            rules.add(new SQLVariableRule((IToken)parameterToken));
        }
        char escapeChar = this.syntaxManager.getEscapeChar();
        String[][] quoteStrings = this.syntaxManager.getQuoteStrings();
        boolean hasSingleQuoteRule = false;
        boolean hasDoubleQuoteRule = false;
        if (!ArrayUtils.isEmpty((Object[])quoteStrings)) {
            int i = 0;
            while (i < quoteStrings.length) {
                rules.add((IRule)new SingleLineRule(quoteStrings[i][0], quoteStrings[i][1], (IToken)quotedToken, escapeChar));
                if (quoteStrings[i][0].equals("'") && quoteStrings[i][0].equals(quoteStrings[i][1])) {
                    hasSingleQuoteRule = true;
                } else if (quoteStrings[i][1].equals("\"") && quoteStrings[i][0].equals(quoteStrings[i][1])) {
                    hasDoubleQuoteRule = true;
                }
                ++i;
            }
        }
        if (!hasSingleQuoteRule) {
            rules.add((IRule)new MultiLineRule("'", "'", (IToken)stringToken, escapeChar));
        }
        if (!hasDoubleQuoteRule) {
            rules.add((IRule)new MultiLineRule("\"", "\"", (IToken)quotedToken, escapeChar));
        }
        if ((multiLineComments = dialect.getMultiLineComments()) != null) {
            rules.add((IRule)new MultiLineRule((String)multiLineComments.getFirst(), (String)multiLineComments.getSecond(), (IToken)commentToken, '\u0000', true));
        }
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new TextWhiteSpaceDetector()));
        if (!minimalRules) {
            rules.add((IRule)new NumberRule((IToken)numberToken));
        }
        SQLDelimiterRule delimRule = new SQLDelimiterRule(this.syntaxManager.getStatementDelimiters(), (IToken)delimiterToken);
        rules.add(delimRule);
        String delimRedefine = dialect.getScriptDelimiterRedefiner();
        if (!CommonUtils.isEmpty((String)delimRedefine)) {
            SQLSetDelimiterToken setDelimiterToken = new SQLSetDelimiterToken(new TextAttribute(this.getColor("org.jkiss.dbeaver.sql.editor.color.command.foreground"), null, 1));
            rules.add(new SQLDelimiterSetRule(delimRedefine, setDelimiterToken, delimRule));
        }
        if (!CommonUtils.isEmpty((String)(blockToggleString = dialect.getBlockToggleString()))) {
            int divPos = blockToggleString.indexOf("\\*\\");
            if (divPos != -1) {
                String prefix = blockToggleString.substring(0, divPos);
                Iterator postfix = blockToggleString.substring(divPos + "\\*\\".length());
                WordPatternRule blockToggleRule = new WordPatternRule((IWordDetector)new SQLWordDetector(), prefix, postfix, (IToken)blockToggleToken);
                rules.add((IRule)blockToggleRule);
            } else {
                WordRule blockToggleRule = new WordRule(SQLRuleManager.getWordOrSymbolDetector(blockToggleString), Token.UNDEFINED, true);
                blockToggleRule.addWord(blockToggleString, (IToken)blockToggleToken);
                rules.add((IRule)blockToggleRule);
            }
        }
        if (!minimalRules) {
            String[][] blockBounds;
            String blockHeaderString;
            if (ruleProvider != null) {
                ruleProvider.extendRules(rules, SQLRuleProvider.RulePosition.KEYWORDS);
            }
            SQLWordRule wordRule = new SQLWordRule(delimRule, (IToken)otherToken);
            for (String reservedWord : dialect.getReservedWords()) {
                wordRule.addWord(reservedWord, (IToken)keywordToken);
            }
            if (dataSource != null) {
                for (String function : dialect.getFunctions(dataSource)) {
                    wordRule.addWord(function, (IToken)typeToken);
                }
                for (String type : dialect.getDataTypes(dataSource)) {
                    wordRule.addWord(type, (IToken)typeToken);
                }
            }
            if (!CommonUtils.isEmpty((String)(blockHeaderString = dialect.getBlockHeaderString()))) {
                wordRule.addWord(blockHeaderString, (IToken)blockHeaderToken);
            }
            if ((blockBounds = dialect.getBlockBoundStrings()) != null) {
                String[][] stringArray2 = blockBounds;
                int n3 = blockBounds.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] block = stringArray2[n4];
                    if (block.length == 2) {
                        wordRule.addWord(block[0], (IToken)blockBeginToken);
                        wordRule.addWord(block[1], (IToken)blockEndToken);
                    }
                    ++n4;
                }
            }
            rules.add(wordRule);
        }
        if (!minimalRules) {
            rules.add(new SQLParameterRule(this.syntaxManager, parameterToken));
        }
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public Color getColor(String colorKey) {
        return this.getColor(colorKey, 2);
    }

    public Color getColor(String colorKey, int colorDefault) {
        ITheme currentTheme = this.themeManager.getCurrentTheme();
        Color color = currentTheme.getColorRegistry().get(colorKey);
        if (color == null) {
            color = Display.getDefault().getSystemColor(colorDefault);
        }
        return color;
    }

    private static IWordDetector getWordOrSymbolDetector(String word) {
        if (Character.isLetterOrDigit(word.charAt(0))) {
            return new SQLWordDetector();
        }
        return new SymbolSequenceDetector(word);
    }

    private static class SymbolSequenceDetector
    implements IWordDetector {
        private final String delimiter;

        public SymbolSequenceDetector(String delimiter) {
            this.delimiter = delimiter;
        }

        public boolean isWordStart(char c) {
            return this.delimiter.charAt(0) == c;
        }

        public boolean isWordPart(char c) {
            return this.delimiter.indexOf(c) != -1;
        }
    }
}

