/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.ProjectRegistry;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.controls.ScriptSelectorPanel;
import org.jkiss.dbeaver.ui.dialogs.connection.SelectDataSourceDialog;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.resources.ResourceUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class OpenHandler
extends AbstractDataSourceHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String actionId = event.getCommand().getId();
        try {
            switch (actionId) {
                case "org.jkiss.dbeaver.core.sql.editor.open": {
                    OpenHandler.openEditor(event);
                    break;
                }
                case "org.jkiss.dbeaver.core.sql.editor.create": {
                    OpenHandler.openNewEditor(event);
                    break;
                }
                case "org.jkiss.dbeaver.core.sql.editor.recent": {
                    OpenHandler.openRecentEditor(event);
                }
            }
        }
        catch (CoreException e) {
            DBUserInterface.getInstance().showError("Open editor", "Can execute command '" + actionId + "'", (Throwable)e);
        }
        return null;
    }

    private static void openEditor(ExecutionEvent event) throws ExecutionException, CoreException {
        List<DBPDataSourceContainer> containers = OpenHandler.getDataSourceContainers(event);
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IProject project = !containers.isEmpty() ? containers.get(0).getRegistry().getProject() : DBeaverCore.getInstance().getProjectRegistry().getActiveProject();
        OpenHandler.checkProjectIsOpen(project);
        DBPDataSourceContainer[] containerList = containers.toArray(new DBPDataSourceContainer[containers.size()]);
        IFolder rootFolder = ResourceUtils.getScriptsFolder(project, true);
        List<ResourceUtils.ResourceInfo> scriptTree = ResourceUtils.findScriptTree(rootFolder, containerList.length == 0 ? null : containerList);
        if (scriptTree.isEmpty() && containerList.length == 1) {
            IFile newScript = ResourceUtils.createNewScript(project, rootFolder, containers.isEmpty() ? null : containers.get(0));
            NavigatorHandlerObjectOpen.openResource((IResource)newScript, workbenchWindow);
        } else {
            ScriptSelectorPanel selector = new ScriptSelectorPanel(workbenchWindow, containerList, rootFolder);
            selector.showTree(scriptTree);
        }
    }

    private static boolean openNewEditor(ExecutionEvent event) throws CoreException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        DBPDataSourceContainer dataSourceContainer = OpenHandler.getCurrentConnection(event);
        IFolder scriptFolder = OpenHandler.getCurrentFolder(event);
        IProject project = dataSourceContainer != null ? dataSourceContainer.getRegistry().getProject() : DBeaverCore.getInstance().getProjectRegistry().getActiveProject();
        OpenHandler.checkProjectIsOpen(project);
        IFile scriptFile = ResourceUtils.createNewScript(project, scriptFolder, dataSourceContainer);
        NavigatorHandlerObjectOpen.openResource((IResource)scriptFile, workbenchWindow);
        return true;
    }

    private static void openRecentEditor(ExecutionEvent event) throws ExecutionException, CoreException {
        DBPDataSourceContainer dataSourceContainer = OpenHandler.getCurrentConnection(event);
        if (dataSourceContainer == null) {
            return;
        }
        OpenHandler.openRecentScript(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), dataSourceContainer, null);
    }

    @Nullable
    private static DBPDataSourceContainer getCurrentConnection(ExecutionEvent event) {
        IProject project;
        DBPDataSourceContainer dataSourceContainer = OpenHandler.getDataSourceContainer(event, false);
        ProjectRegistry projectRegistry = DBeaverCore.getInstance().getProjectRegistry();
        IProject iProject = project = dataSourceContainer != null ? dataSourceContainer.getRegistry().getProject() : projectRegistry.getActiveProject();
        if (dataSourceContainer == null) {
            DataSourceRegistry dataSourceRegistry = projectRegistry.getDataSourceRegistry(project);
            if (dataSourceRegistry == null) {
                return null;
            }
            if (dataSourceRegistry.getDataSources().size() == 1) {
                dataSourceContainer = dataSourceRegistry.getDataSources().get(0);
            } else if (!dataSourceRegistry.getDataSources().isEmpty()) {
                SelectDataSourceDialog dialog = new SelectDataSourceDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), project, null);
                if (dialog.open() == 1) {
                    return null;
                }
                dataSourceContainer = dialog.getDataSource();
            }
        }
        return dataSourceContainer;
    }

    @Nullable
    private static IFolder getCurrentFolder(ExecutionEvent event) {
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof DBNResource && ((DBNResource)element).getResource() instanceof IFolder) {
            return (IFolder)((DBNResource)element).getResource();
        }
        return null;
    }

    private static List<DBPDataSourceContainer> getDataSourceContainers(ExecutionEvent event) {
        IWorkbenchPart activePart;
        DBPDataSourceContainer partContainer;
        ArrayList<DBPDataSourceContainer> containers = new ArrayList<DBPDataSourceContainer>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof DBNLocalFolder) {
                    for (DBNDataSource ds : ((DBNLocalFolder)obj).getDataSources()) {
                        containers.add(ds.getDataSourceContainer());
                    }
                } else {
                    DBSObject selectedObject = DBUtils.getFromObject((Object)obj);
                    if (selectedObject != null) {
                        if (selectedObject instanceof DBPDataSourceContainer) {
                            containers.add((DBPDataSourceContainer)selectedObject);
                        } else {
                            containers.add(selectedObject.getDataSource().getContainer());
                        }
                    }
                }
                ++n2;
            }
        }
        if (containers.isEmpty() && (partContainer = OpenHandler.getDataSourceContainers(activePart = HandlerUtil.getActivePart((ExecutionEvent)event))) != null) {
            containers.add(partContainer);
        }
        return containers;
    }

    private static DBPDataSourceContainer getDataSourceContainers(IWorkbenchPart activePart) {
        if (activePart instanceof IDataSourceContainerProvider) {
            return ((IDataSourceContainerProvider)activePart).getDataSourceContainer();
        }
        if (activePart instanceof DBPContextProvider) {
            DBCExecutionContext context = ((DBPContextProvider)activePart).getExecutionContext();
            return context == null ? null : context.getDataSource().getContainer();
        }
        return null;
    }

    public static void openRecentScript(@NotNull IWorkbenchWindow workbenchWindow, @Nullable DBPDataSourceContainer dataSourceContainer, @Nullable IFolder scriptFolder) throws CoreException {
        IProject project = dataSourceContainer != null ? dataSourceContainer.getRegistry().getProject() : DBeaverCore.getInstance().getProjectRegistry().getActiveProject();
        OpenHandler.checkProjectIsOpen(project);
        ResourceUtils.ResourceInfo res = ResourceUtils.findRecentScript(project, dataSourceContainer);
        if (res != null) {
            NavigatorHandlerObjectOpen.openResourceEditor(workbenchWindow, res);
        } else {
            IFile scriptFile = ResourceUtils.createNewScript(project, scriptFolder, dataSourceContainer);
            NavigatorHandlerObjectOpen.openResource((IResource)scriptFile, workbenchWindow);
        }
    }

    private static void checkProjectIsOpen(final IProject project) throws CoreException {
        if (project == null) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)new IllegalStateException("No active project.")));
        }
        if (!project.isOpen()) {
            try {
                DBeaverUI.runInProgressService(new DBRRunnableWithProgress(){

                    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            project.open(monitor.getNestedMonitor());
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw (CoreException)e.getTargetException();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static SQLEditor openSQLConsole(IWorkbenchWindow workbenchWindow, DBPDataSourceContainer dataSourceContainer, String name, String sqlText) {
        StringEditorInput sqlInput = new StringEditorInput(name, sqlText, false, "UTF-8");
        return OpenHandler.openSQLConsole(workbenchWindow, dataSourceContainer, sqlInput);
    }

    public static SQLEditor openSQLConsole(IWorkbenchWindow workbenchWindow, DBPDataSourceContainer dataSourceContainer, IEditorInput sqlInput) {
        EditorUtils.setInputDataSource(sqlInput, dataSourceContainer, false);
        return OpenHandler.openSQLEditor(workbenchWindow, sqlInput);
    }

    public static SQLEditor openSQLEditor(IWorkbenchWindow workbenchWindow, IEditorInput sqlInput) {
        try {
            return (SQLEditor)workbenchWindow.getActivePage().openEditor(sqlInput, SQLEditor.class.getName());
        }
        catch (PartInitException e) {
            DBUserInterface.getInstance().showError("Can't open editor", null, (Throwable)e);
            return null;
        }
    }
}

