/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.format.tokenized;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.format.BaseFormatterConfigurationPage;

public class SQLTokenizedConfigurationPage
extends BaseFormatterConfigurationPage {
    private Spinner indentSizeSpinner;
    private Button useSpacesCheck;
    private Button compactFormatCheck;
    private Combo keywordCaseCombo;

    @Override
    protected Composite createFormatSettings(Composite parent, SQLFormatterConfiguration configuration) {
        Group settings = UIUtils.createControlGroup(parent, "Settings", 2, 768, 0);
        this.keywordCaseCombo = UIUtils.createLabelCombo((Composite)settings, CoreMessages.pref_page_sql_format_label_keyword_case, 12);
        this.keywordCaseCombo.setLayoutData((Object)new GridData(32));
        this.keywordCaseCombo.add("Default");
        DBPIdentifierCase[] dBPIdentifierCaseArray = DBPIdentifierCase.values();
        int n = dBPIdentifierCaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPIdentifierCase c = dBPIdentifierCaseArray[n2];
            this.keywordCaseCombo.add(DBPIdentifierCase.capitalizeCaseName((String)c.name()));
            ++n2;
        }
        DBPIdentifierCase keywordCase = configuration.getKeywordCase();
        if (keywordCase == null) {
            this.keywordCaseCombo.select(0);
        } else {
            UIUtils.setComboSelection(this.keywordCaseCombo, DBPIdentifierCase.capitalizeCaseName((String)keywordCase.name()));
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean useSpaces = preferenceStore.getBoolean("spacesForTabs");
        int tabWidth = preferenceStore.getInt("tabWidth");
        this.indentSizeSpinner = UIUtils.createLabelSpinner((Composite)settings, "Indent size", "Insert spaces for tabs", tabWidth, 0, 100);
        this.useSpacesCheck = UIUtils.createCheckbox((Composite)settings, "Insert spaces for tabs", "Insert spaces for tabs", useSpaces, 2);
        this.compactFormatCheck = UIUtils.createCheckbox((Composite)settings, "Compact formatting", "Compact formatting. Less line feeds and indentation", false, 2);
        return parent;
    }

    @Override
    protected void saveFormatSettings(SQLFormatterConfiguration configuration) {
    }

    private IPreferenceStore getPreferenceStore() {
        return EditorsPlugin.getDefault().getPreferenceStore();
    }
}

