/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.format;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.registry.sql.SQLFormatterConfigurer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public abstract class BaseFormatterConfigurationPage
extends ActiveWizardPage
implements SQLFormatterConfigurer {
    public BaseFormatterConfigurationPage() {
        super("SQL Format");
    }

    public void performHelp() {
        super.performHelp();
    }

    public final void createControl(Composite parent) {
        this.setTitle("SQL Format Configuration");
        this.setDescription(this.getWizard().getFormaterName());
        Composite composite = this.createFormatSettings(parent, this.getWizard().getConfiguration());
        this.setControl((Control)composite);
    }

    public ConfigWizard getWizard() {
        return (ConfigWizard)((Object)super.getWizard());
    }

    protected abstract Composite createFormatSettings(Composite var1, SQLFormatterConfiguration var2);

    protected abstract void saveFormatSettings(SQLFormatterConfiguration var1);

    @Override
    public boolean configure(String formatName, SQLFormatter formatter, SQLFormatterConfiguration configuration) {
        ConfigWizard wizard = new ConfigWizard(formatName, configuration);
        wizard.addPage((IWizardPage)this);
        WizardDialog configDialog = new WizardDialog(DBeaverUI.getActiveWorkbenchShell(), (IWizard)wizard){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                UIUtils.createCheckbox(parent, "Don't show again", false);
                ++((GridLayout)parent.getLayout()).numColumns;
            }
        };
        return configDialog.open() == 0;
    }

    protected static class ConfigWizard
    extends Wizard {
        private final SQLFormatterConfiguration configuration;
        private String formaterName;

        public ConfigWizard(String formaterName, SQLFormatterConfiguration configuration) {
            this.setWindowTitle("SQL Format");
            this.formaterName = formaterName;
            this.configuration = configuration;
        }

        public SQLFormatterConfiguration getConfiguration() {
            return this.configuration;
        }

        public boolean performFinish() {
            IWizardPage[] iWizardPageArray = this.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                if (page instanceof BaseFormatterConfigurationPage) {
                    ((BaseFormatterConfigurationPage)page).saveFormatSettings(this.configuration);
                }
                ++n2;
            }
            return true;
        }

        public String getFormaterName() {
            return this.formaterName;
        }
    }
}

