/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorNested;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;

public class SQLSourceViewer<T extends DBPScriptObject & DBSObject>
extends SQLEditorNested<T> {
    private IAction OPEN_CONSOLE_ACTION = new Action("Open in SQL console", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE)){

        public void run() {
            DBPDataSource dataSource = SQLSourceViewer.this.getDataSource();
            OpenHandler.openSQLConsole(DBeaverUI.getActiveWorkbenchWindow(), dataSource == null ? null : dataSource.getContainer(), "Source", SQLSourceViewer.this.getDocument().get());
        }
    };

    @Override
    protected String getSourceText(DBRProgressMonitor monitor) throws DBException {
        return ((DBPScriptObject)this.getSourceObject()).getObjectDefinitionText(monitor, this.getSourceOptions());
    }

    protected Map<String, Object> getSourceOptions() {
        IDatabaseEditorInput editorInput = this.getEditorInput();
        Collection<String> attributeNames = editorInput.getAttributeNames();
        if (attributeNames.isEmpty()) {
            return DBPScriptObject.EMPTY_OPTIONS;
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (String name : attributeNames) {
            Object attribute = editorInput.getAttribute(name);
            options.put(name, attribute);
        }
        return options;
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }

    @Override
    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
    }

    @Override
    protected void contributeEditorCommands(IContributionManager toolBarManager) {
        super.contributeEditorCommands(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.OPEN_CONSOLE_ACTION);
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.insertAfter("sql.additions", this.OPEN_CONSOLE_ACTION);
    }
}

