/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;

public class CreateProcedurePage
extends BaseObjectEditPage {
    private DBSObjectContainer container;
    private String name;
    private DBSProcedureType type;

    public CreateProcedurePage(DBSObjectContainer container) {
        super(CoreMessages.dialog_struct_create_procedure_title);
        this.container = container;
    }

    @Override
    protected Control createPageContents(Composite parent) {
        Composite propsGroup = new Composite(parent, 0);
        propsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        propsGroup.setLayoutData((Object)gd);
        UIUtils.createLabelText(propsGroup, "Container", DBUtils.getObjectFullName((DBPNamedObject)this.container, (DBPEvaluationContext)DBPEvaluationContext.UI)).setEditable(false);
        final Text nameText = UIUtils.createLabelText(propsGroup, CoreMessages.dialog_struct_create_procedure_label_name, null);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProcedurePage.this.name = nameText.getText();
            }
        });
        final Combo typeCombo = UIUtils.createLabelCombo(propsGroup, CoreMessages.dialog_struct_create_procedure_combo_type, 12);
        typeCombo.add(DBSProcedureType.PROCEDURE.name());
        typeCombo.add(DBSProcedureType.FUNCTION.name());
        typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProcedurePage.this.type = typeCombo.getSelectionIndex() == 0 ? DBSProcedureType.PROCEDURE : DBSProcedureType.FUNCTION;
                nameText.setText(CreateProcedurePage.this.type == DBSProcedureType.PROCEDURE ? "NewProcedure" : "NewFunction");
            }
        });
        typeCombo.select(0);
        propsGroup.setTabList(new Control[]{nameText, typeCombo});
        return propsGroup;
    }

    public DBSProcedureType getProcedureType() {
        return this.type;
    }

    public String getProcedureName() {
        return DBObjectNameCaseTransformer.transformName((DBPDataSource)this.container.getDataSource(), (String)this.name);
    }
}

