/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary.pref;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.editors.binary.pref.HexPreferencesManager;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class HexPreferencesPage
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PROP_FONT_DATA = "prop.hex.font.data";
    public static final String PROP_DEF_WIDTH = "default.hex.width";
    private HexPreferencesManager preferences = null;

    public static FontData getPrefFontData() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        String fontName = store.getString("hex.font.name");
        int fontStyle = store.getInt("hex.font.style");
        int fontSize = store.getInt("hex.font.size");
        if (!CommonUtils.isEmpty((String)fontName) && fontSize > 0) {
            return new FontData(fontName, fontSize, fontStyle);
        }
        return null;
    }

    public static String getDefaultWidth() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        return store.getString(PROP_DEF_WIDTH);
    }

    protected Control createContents(Composite parent) {
        FontData fontData = HexPreferencesPage.getPrefFontData();
        String defWidth = HexPreferencesPage.getDefaultWidth();
        this.preferences = new HexPreferencesManager(fontData, defWidth);
        return this.preferences.createPreferencesPart(parent);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.preferences.setFontData(null);
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        FontData fontData = this.preferences.getFontData();
        store.setValue("hex.font.name", fontData.getName());
        store.setValue("hex.font.style", fontData.getStyle());
        store.setValue("hex.font.size", fontData.getHeight());
        store.firePropertyChangeEvent(PROP_FONT_DATA, null, (Object)fontData);
        store.setValue(PROP_DEF_WIDTH, this.preferences.getDefWidth());
        store.firePropertyChangeEvent(PROP_DEF_WIDTH, (Object)0, (Object)this.preferences.getDefWidth());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }
}

