/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;

public class DatabaseEditorUtils {
    public static void setPartBackground(IEditorPart editor, Composite composite) {
        DBCExecutionContext context;
        CTabFolder tabFolder = null;
        Composite rootComposite = null;
        Composite c = composite;
        while (c != null) {
            if (c.getParent() instanceof CTabFolder) {
                tabFolder = (CTabFolder)c.getParent();
                rootComposite = c;
                break;
            }
            c = c.getParent();
        }
        if (tabFolder == null) {
            return;
        }
        tabFolder.setBorderVisible(false);
        Color bgColor = null;
        if (editor instanceof IDataSourceContainerProvider) {
            DBPDataSourceContainer container = ((IDataSourceContainerProvider)editor).getDataSourceContainer();
            if (container != null) {
                bgColor = UIUtils.getConnectionColor(container.getConnectionConfiguration());
            }
        } else if (editor instanceof DBPContextProvider && (context = ((DBPContextProvider)editor).getExecutionContext()) != null) {
            bgColor = UIUtils.getConnectionColor(context.getDataSource().getContainer().getConnectionConfiguration());
        }
        if (bgColor == null) {
            rootComposite.setBackground(null);
        } else {
            rootComposite.setBackground(bgColor);
        }
    }

    public static void contributeStandardEditorActions(IWorkbenchSite workbenchSite, IContributionManager contributionManager) {
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, "org.eclipse.ui.file.save", null, (DBPImage)UIIcon.SAVE, null, true));
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, "org.eclipse.ui.file.revert", null, (DBPImage)UIIcon.RESET, null, true));
    }
}

