/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.net;

import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.impl.net.SSHConstants;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.utils.CommonUtils;

public class SSHTunnelConfiguratorUI
implements IObjectPropertyConfigurator<DBWHandlerConfiguration> {
    private Text hostText;
    private Spinner portText;
    private Text userNameText;
    private Combo authMethodCombo;
    private TextWithOpen privateKeyText;
    private Label pwdLabel;
    private Text passwordText;
    private Button savePasswordCheckbox;
    private Label privateKeyLabel;
    private Spinner localPortSpinner;
    private Spinner keepAliveText;
    private Spinner tunnelTimeout;

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group settingsGroup = UIUtils.createControlGroup(composite, CoreMessages.model_ssh_configurator_group_settings, 2, 768, -1);
        this.hostText = UIUtils.createLabelText((Composite)settingsGroup, CoreMessages.model_ssh_configurator_label_host_ip, null, 2048, new GridData(768));
        this.portText = UIUtils.createLabelSpinner((Composite)settingsGroup, CoreMessages.model_ssh_configurator_label_port, 22, 0, 65535);
        this.userNameText = UIUtils.createLabelText((Composite)settingsGroup, CoreMessages.model_ssh_configurator_label_user_name, null, 2048, new GridData(768));
        this.authMethodCombo = UIUtils.createLabelCombo((Composite)settingsGroup, CoreMessages.model_ssh_configurator_combo_auth_method, 12);
        this.authMethodCombo.setLayoutData((Object)new GridData(32));
        this.authMethodCombo.add(CoreMessages.model_ssh_configurator_combo_password);
        this.authMethodCombo.add(CoreMessages.model_ssh_configurator_combo_pub_key);
        this.privateKeyLabel = UIUtils.createControlLabel((Composite)settingsGroup, CoreMessages.model_ssh_configurator_label_private_key);
        this.privateKeyLabel.setLayoutData((Object)new GridData(32));
        this.privateKeyText = new TextWithOpenFile((Composite)settingsGroup, CoreMessages.model_ssh_configurator_dialog_choose_private_key, new String[]{"*", "*.ssh", "*.pem", "*.*"});
        this.privateKeyText.setLayoutData(new GridData(768));
        this.pwdLabel = UIUtils.createControlLabel((Composite)settingsGroup, CoreMessages.model_ssh_configurator_label_password);
        this.passwordText = new Text((Composite)settingsGroup, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        this.savePasswordCheckbox = UIUtils.createLabelCheckbox((Composite)settingsGroup, CoreMessages.model_ssh_configurator_checkbox_save_pass, false);
        Group advancedGroup = UIUtils.createControlGroup(composite, CoreMessages.model_ssh_configurator_group_advanced, 2, 768, -1);
        this.localPortSpinner = UIUtils.createLabelSpinner((Composite)advancedGroup, CoreMessages.model_ssh_configurator_label_local_port, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.localPortSpinner.setToolTipText(CoreMessages.model_ssh_configurator_label_local_port_description);
        this.keepAliveText = UIUtils.createLabelSpinner((Composite)advancedGroup, CoreMessages.model_ssh_configurator_label_keep_alive, 0, 0, Integer.MAX_VALUE);
        this.tunnelTimeout = UIUtils.createLabelSpinner((Composite)advancedGroup, CoreMessages.model_ssh_configurator_label_tunnel_timeout, 10000, 0, 300000);
        this.authMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHTunnelConfiguratorUI.this.updatePrivateKeyVisibility();
            }
        });
    }

    @Override
    public void loadSettings(DBWHandlerConfiguration configuration) {
        String timeoutString;
        String kaString;
        this.hostText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("host"))));
        String portString = (String)configuration.getProperties().get("port");
        if (!CommonUtils.isEmpty((String)portString)) {
            this.portText.setSelection(CommonUtils.toInt((Object)portString));
        }
        this.userNameText.setText(CommonUtils.notEmpty((String)configuration.getUserName()));
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        String authTypeName = (String)configuration.getProperties().get("authType");
        if (!CommonUtils.isEmpty((String)authTypeName)) {
            authType = SSHConstants.AuthType.valueOf((String)authTypeName);
        }
        this.authMethodCombo.select(authType == SSHConstants.AuthType.PASSWORD ? 0 : 1);
        this.privateKeyText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("keyPath"))));
        this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getPassword()));
        this.savePasswordCheckbox.setSelection(configuration.isSavePassword());
        String lpString = (String)configuration.getProperties().get("localPort");
        if (!CommonUtils.isEmpty((String)lpString)) {
            this.localPortSpinner.setSelection(Integer.parseInt(lpString));
        }
        if (!CommonUtils.isEmpty((String)(kaString = (String)configuration.getProperties().get("aliveInterval")))) {
            this.keepAliveText.setSelection(Integer.parseInt(kaString));
        }
        if (!CommonUtils.isEmpty((String)(timeoutString = (String)configuration.getProperties().get("sshConnectTimeout")))) {
            this.tunnelTimeout.setSelection(CommonUtils.toInt((Object)timeoutString));
        }
        this.updatePrivateKeyVisibility();
    }

    @Override
    public void saveSettings(DBWHandlerConfiguration configuration) {
        Map properties = configuration.getProperties();
        properties.clear();
        properties.put("host", this.hostText.getText());
        properties.put("port", this.portText.getText());
        properties.put("authType", this.authMethodCombo.getSelectionIndex() == 0 ? SSHConstants.AuthType.PASSWORD.name() : SSHConstants.AuthType.PUBLIC_KEY.name());
        properties.put("keyPath", this.privateKeyText.getText());
        configuration.setUserName(this.userNameText.getText());
        configuration.setPassword(this.passwordText.getText());
        configuration.setSavePassword(this.savePasswordCheckbox.getSelection());
        int localPort = this.localPortSpinner.getSelection();
        if (localPort <= 0) {
            properties.remove("localPort");
        } else {
            properties.put("localPort", String.valueOf(localPort));
        }
        int kaInterval = this.keepAliveText.getSelection();
        if (kaInterval <= 0) {
            properties.remove("aliveInterval");
        } else {
            properties.put("aliveInterval", String.valueOf(kaInterval));
        }
        properties.put("sshConnectTimeout", this.tunnelTimeout.getText());
    }

    private void updatePrivateKeyVisibility() {
        boolean isPassword;
        ((GridData)this.privateKeyLabel.getLayoutData()).exclude = isPassword = this.authMethodCombo.getSelectionIndex() == 0;
        this.privateKeyLabel.setVisible(!isPassword);
        ((GridData)this.privateKeyText.getLayoutData()).exclude = isPassword;
        this.privateKeyText.setVisible(!isPassword);
        this.pwdLabel.setText(isPassword ? CoreMessages.model_ssh_configurator_label_password : CoreMessages.model_ssh_configurator_label_passphrase);
        DBeaverUI.asyncExec(new Runnable(){

            @Override
            public void run() {
                SSHTunnelConfiguratorUI.this.hostText.getParent().getParent().layout(true, true);
            }
        });
    }

    @Override
    public boolean isComplete() {
        return false;
    }
}

