/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.registry.driver.DriverDependencies;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadWizard;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;

public class DriverDownloadDialog
extends WizardDialog {
    private static final String DIALOG_ID = "DBeaver.DriverDownloadDialog";
    public static final int EDIT_DRIVER_BUTTON_ID = 2000;
    private boolean doDownload = false;

    DriverDownloadDialog(Shell shell, DriverDescriptor driver, DriverDependencies dependencies, boolean updateVersion, boolean forceDownload) {
        super(shell, (IWizard)new DriverDownloadWizard(driver, dependencies, updateVersion, forceDownload));
        this.getWizard().init(DBeaverUI.getActiveWorkbenchWindow().getWorkbench(), null);
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(final PageChangedEvent event) {
                DBeaverUI.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DriverDownloadDialog.this.getWizard().pageActivated(event.getSelectedPage());
                    }
                });
            }
        });
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    DriverDescriptor getDriver() {
        return this.getWizard().getDriver();
    }

    public DriverDownloadWizard getWizard() {
        return (DriverDownloadWizard)super.getWizard();
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogArea = super.createDialogArea(parent);
        if (this.getWizard().isForceDownload()) {
            DBeaverUI.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DriverDownloadDialog.this.buttonPressed(16);
                }
            });
        }
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        DriverDownloadWizard wizard = this.getWizard();
        if (!wizard.isForceDownload() && DriverEditDialog.getDialogCount() == 0) {
            this.createButton(parent, 2000, wizard.isAutoDownloadWizard() ? CoreMessages.dialog_driver_download_button_edit_dirver : CoreMessages.dialog_driver_download_button_add_jars, false);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 16) {
            Button button = super.createButton(parent, id, this.getWizard().getFinishText(), defaultButton);
            button.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.BROWSER));
            this.setButtonLayoutData(button);
            return button;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    public void buttonPressed(int buttonId) {
        if (buttonId == 2000) {
            this.cancelPressed();
            DriverEditDialog dialog = new DriverEditDialog(null, this.getDriver());
            dialog.open(!this.getWizard().isAutoDownloadWizard());
        }
        super.buttonPressed(buttonId);
    }

    protected void finishPressed() {
        this.doDownload = true;
        super.finishPressed();
    }

    void closeWizard() {
        DBeaverUI.asyncExec(new Runnable(){

            @Override
            public void run() {
                DriverDownloadDialog.this.buttonPressed(1);
            }
        });
    }

    public static boolean downloadDriverFiles(Shell shell, DriverDescriptor driver, DriverDependencies dependencies) {
        return DriverDownloadDialog.downloadDriverFiles(shell, driver, dependencies, false);
    }

    public static boolean downloadDriverFiles(Shell shell, DriverDescriptor driver, DriverDependencies dependencies, boolean forceDownload) {
        DriverDownloadDialog dialog = new DriverDownloadDialog(shell, driver, dependencies, false, forceDownload);
        dialog.setMinimumPageSize(100, 100);
        dialog.open();
        return dialog.doDownload;
    }

    public static boolean updateDriverFiles(Shell shell, DriverDescriptor driver, DriverDependencies dependencies, boolean forceDownload) {
        DriverDownloadDialog dialog = new DriverDownloadDialog(shell, driver, dependencies, true, forceDownload);
        dialog.setMinimumPageSize(100, 100);
        dialog.open();
        return dialog.doDownload;
    }
}

