/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class ConnectionPageSettings
extends ActiveWizardPage<ConnectionWizard>
implements IDataSourceConnectionEditorSite,
ICompositeDialogPage,
IDataSourceConnectionTester {
    private static final Log log = Log.getLog(DriverDescriptor.class);
    @NotNull
    private final ConnectionWizard wizard;
    @NotNull
    private DataSourceViewDescriptor viewDescriptor;
    @Nullable
    private IDataSourceConnectionEditor connectionEditor;
    @Nullable
    private DataSourceDescriptor dataSource;
    private final Set<DataSourceDescriptor> activated = new HashSet<DataSourceDescriptor>();
    private IDialogPage[] subPages;
    private IDialogPage[] extraPages;
    private TabFolder tabFolder;

    ConnectionPageSettings(@NotNull ConnectionWizard wizard, @NotNull DataSourceViewDescriptor viewDescriptor) {
        super("newConnectionSettings");
        this.wizard = wizard;
        this.viewDescriptor = viewDescriptor;
        this.setTitle(wizard.isNew() ? viewDescriptor.getLabel() : CoreMessages.dialog_setting_connection_wizard_title);
        this.setDescription(CoreMessages.dialog_connection_description);
    }

    ConnectionPageSettings(@NotNull ConnectionWizard wizard, @NotNull DataSourceViewDescriptor viewDescriptor, @Nullable DataSourceDescriptor dataSource) {
        this(wizard, viewDescriptor);
        this.dataSource = dataSource;
    }

    @Override
    public void activatePage() {
        if (this.connectionEditor == null) {
            this.createProviderPage(this.getControl().getParent());
        }
        this.setMessage(NLS.bind((String)CoreMessages.dialog_connection_message, (Object)this.getDriver().getFullName()));
        DataSourceDescriptor connectionInfo = this.getActiveDataSource();
        if (!this.activated.contains(connectionInfo)) {
            if (this.connectionEditor != null) {
                this.connectionEditor.loadSettings();
            }
            if (this.subPages != null) {
                IDialogPage[] iDialogPageArray = this.subPages;
                int n = this.subPages.length;
                int n2 = 0;
                while (n2 < n) {
                    IDialogPage page = iDialogPageArray[n2];
                    Control pageControl = page.getControl();
                    if (pageControl != null && page instanceof IDataSourceConnectionEditor) {
                        ((IDataSourceConnectionEditor)page).loadSettings();
                    }
                    ++n2;
                }
            }
            this.activated.add(connectionInfo);
        } else if (this.connectionEditor != null) {
            this.connectionEditor.loadSettings();
        }
        this.activateCurrentItem();
        this.getContainer().updateTitleBar();
    }

    @Override
    public void deactivatePage() {
        DataSourceDescriptor connectionInfo = this.getActiveDataSource();
        if (this.activated.contains(connectionInfo) && this.connectionEditor != null) {
            this.connectionEditor.saveSettings(connectionInfo);
        }
        super.deactivatePage();
    }

    public Image getImage() {
        Image image;
        if (this.connectionEditor != null && (image = this.connectionEditor.getImage()) != null) {
            return image;
        }
        return super.getImage();
    }

    void saveSettings(DataSourceDescriptor dataSource) {
        if (this.connectionEditor != null) {
            this.connectionEditor.saveSettings(dataSource);
        }
        if (this.subPages != null) {
            IDialogPage[] iDialogPageArray = this.subPages;
            int n = this.subPages.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogPage page = iDialogPageArray[n2];
                if (page.getControl() != null && page instanceof IDataSourceConnectionEditor) {
                    ((IDataSourceConnectionEditor)page).saveSettings(dataSource);
                }
                ++n2;
            }
        }
    }

    public void createControl(Composite parent) {
        if (this.wizard.isNew()) {
            this.setControl((Control)new Composite(parent, 2048));
        } else {
            this.createProviderPage(parent);
        }
    }

    private void createProviderPage(Composite parent) {
        if (this.connectionEditor != null && this.connectionEditor.getControl() != null) {
            return;
        }
        if (this.getControl() != null) {
            this.getControl().dispose();
        }
        try {
            if (this.connectionEditor == null) {
                this.connectionEditor = this.viewDescriptor.createView(IDataSourceConnectionEditor.class);
                this.connectionEditor.setSite(this);
            }
            this.getSubPages();
            if (this.wizard.isNew() && !ArrayUtils.isEmpty((Object[])this.subPages)) {
                ArrayList<IDataSourceConnectionEditor> allPages = new ArrayList<IDataSourceConnectionEditor>();
                allPages.add(this.connectionEditor);
                Collections.addAll(allPages, this.subPages);
                this.tabFolder = new TabFolder(parent, 128);
                this.tabFolder.setLayoutData((Object)new GridData(1808));
                this.setControl((Control)this.tabFolder);
                for (IDialogPage iDialogPage : allPages) {
                    TabItem item = new TabItem(this.tabFolder, 0);
                    iDialogPage.createControl((Composite)this.tabFolder);
                    item.setData((Object)iDialogPage);
                    Control pageControl = iDialogPage.getControl();
                    item.setControl(pageControl);
                    item.setText(CommonUtils.isEmpty((String)iDialogPage.getTitle()) ? CoreMessages.dialog_setting_connection_general : iDialogPage.getTitle());
                    item.setToolTipText(iDialogPage.getDescription());
                }
                this.tabFolder.setSelection(0);
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConnectionPageSettings.this.activateCurrentItem();
                    }
                });
            } else {
                this.connectionEditor.createControl(parent);
                this.setControl(this.connectionEditor.getControl());
            }
            UIUtils.setHelp(this.getControl(), "con-wizard-settings");
        }
        catch (Exception ex) {
            log.warn((Object)ex);
            this.setErrorMessage("Can't create settings dialog: " + ex.getMessage());
        }
        parent.layout();
    }

    private void activateCurrentItem() {
        TabItem[] selection;
        if (this.tabFolder != null && (selection = this.tabFolder.getSelection()).length == 1) {
            IDialogPage page = (IDialogPage)selection[0].getData();
            page.setVisible(true);
        }
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public boolean isPageComplete() {
        return this.wizard.getPageSettings() != this || this.connectionEditor != null && this.connectionEditor.isComplete();
    }

    @Override
    public DBRRunnableContext getRunnableContext() {
        return new RunnableContextDelegate((IRunnableContext)this.wizard.getContainer());
    }

    @Override
    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.wizard.getDataSourceRegistry();
    }

    @Override
    public boolean isNew() {
        return this.wizard.isNew();
    }

    @Override
    public DriverDescriptor getDriver() {
        return this.wizard.getSelectedDriver();
    }

    @Override
    @NotNull
    public DataSourceDescriptor getActiveDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        return this.wizard.getActiveDataSource();
    }

    @Override
    public void updateButtons() {
        ((ConnectionWizard)((Object)this.getWizard())).getContainer().updateButtons();
    }

    @Override
    public boolean openDriverEditor() {
        DriverEditDialog dialog = new DriverEditDialog(this.wizard.getShell(), this.getDriver());
        return dialog.open() == 0;
    }

    @Override
    public boolean openSettingsPage(String pageId) {
        IWizardPage page = this.wizard.getPage(pageId);
        if (page != null) {
            this.wizard.getContainer().showPage(page);
        }
        return false;
    }

    @Override
    public void testConnection() {
        ((ConnectionWizard)((Object)this.getWizard())).testConnection();
    }

    public void dispose() {
        if (this.connectionEditor != null) {
            this.connectionEditor.dispose();
            this.connectionEditor = null;
        }
        super.dispose();
    }

    @Override
    @Nullable
    public IDialogPage[] getSubPages() {
        if (this.subPages != null) {
            return this.subPages;
        }
        if (this.connectionEditor == null) {
            this.connectionEditor = this.viewDescriptor.createView(IDataSourceConnectionEditor.class);
            this.connectionEditor.setSite(this);
        }
        if (this.connectionEditor instanceof ICompositeDialogPage) {
            this.subPages = ((ICompositeDialogPage)((Object)this.connectionEditor)).getSubPages();
            if (!ArrayUtils.isEmpty((Object[])this.subPages)) {
                IDialogPage[] iDialogPageArray = this.subPages;
                int n = this.subPages.length;
                int n2 = 0;
                while (n2 < n) {
                    IDialogPage page = iDialogPageArray[n2];
                    if (page instanceof IDataSourceConnectionEditor) {
                        ((IDataSourceConnectionEditor)page).setSite(this);
                    }
                    ++n2;
                }
            }
            if (this.extraPages != null) {
                this.subPages = (IDialogPage[])ArrayUtils.concatArrays((Object[])this.subPages, (Object[])this.extraPages);
            }
            return this.subPages;
        }
        return this.extraPages;
    }

    public void addSubPage(IDialogPage page) {
        this.extraPages = this.extraPages == null ? new IDialogPage[]{page} : (IDialogPage[])ArrayUtils.concatArrays((Object[])this.extraPages, (Object[])new IDialogPage[]{page});
    }

    @Override
    public void testConnection(DBCSession session) {
        if (this.connectionEditor instanceof IDataSourceConnectionTester) {
            ((IDataSourceConnectionTester)((Object)this.connectionEditor)).testConnection(session);
        }
    }
}

