/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;

public class ConfirmationDialog
extends MessageDialogWithToggle {
    public static final String PREF_KEY_PREFIX = "org.jkiss.dbeaver.core.confirm.";
    public static final String RES_KEY_TITLE = "title";
    public static final String RES_KEY_MESSAGE = "message";
    public static final String RES_KEY_TOGGLE_MESSAGE = "toggleMessage";
    public static final String RES_CONFIRM_PREFIX = "confirm_";

    public ConfirmationDialog(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        super(parentShell, dialogTitle, image, message, dialogImageType, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
    }

    public static int open(int kind, int imageKind, Shell parent, String title, String message, String toggleMessage, boolean toggleState, String key) {
        DBPPreferenceStore prefStore = DBeaverCore.getGlobalPreferenceStore();
        if ("always".equals(prefStore.getString(key))) {
            if (kind == 3 || kind == 6) {
                return 2;
            }
            return 0;
        }
        if ("never".equals(prefStore.getString(key))) {
            if (kind == 3 || kind == 6) {
                return 3;
            }
            return 1;
        }
        ConfirmationDialog dialog = new ConfirmationDialog(parent == null ? DBeaverUI.getActiveWorkbenchShell() : parent, title, null, message, imageKind, ConfirmationDialog.getButtonLabels(kind), ConfirmationDialog.getDefaultIndex(kind, imageKind), toggleMessage, toggleState);
        dialog.setPrefStore(new PreferenceStoreDelegate(prefStore));
        dialog.setPrefKey(key);
        return dialog.open();
    }

    public static String[] getButtonLabels(int kind) {
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                return new String[]{IDialogConstants.OK_LABEL};
            }
            case 5: {
                return new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            }
            case 3: {
                return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            }
            case 6: {
                return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            }
        }
        throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
    }

    public static int getDefaultIndex(int kind, int imageKind) {
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                return 0;
            }
            case 5: {
                if (imageKind == 4) {
                    return 1;
                }
                return 0;
            }
            case 3: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
    }

    public static boolean confirmAction(Shell shell, String id) {
        return ConfirmationDialog.confirmActionWithParams(shell, id, new Object[0]);
    }

    public static boolean confirmActionWithParams(Shell shell, String id, Object ... args) {
        return ConfirmationDialog.showConfirmDialog(shell, id, 5, args) == 0;
    }

    public static int showConfirmDialog(@Nullable Shell shell, String id, int type, Object ... args) {
        return ConfirmationDialog.showConfirmDialogEx(shell, id, type, type, args);
    }

    public static String getSavedPreference(String id) {
        DBPPreferenceStore prefStore = DBeaverCore.getGlobalPreferenceStore();
        return prefStore.getString(PREF_KEY_PREFIX + id);
    }

    public static int showConfirmDialogEx(Shell shell, String id, int type, int imageType, Object ... args) {
        ResourceBundle bundle = DBeaverActivator.getCoreResourceBundle();
        String titleKey = ConfirmationDialog.getResourceKey(id, RES_KEY_TITLE);
        String messageKey = ConfirmationDialog.getResourceKey(id, RES_KEY_MESSAGE);
        String toggleKey = ConfirmationDialog.getResourceKey(id, RES_KEY_TOGGLE_MESSAGE);
        String prefKey = PREF_KEY_PREFIX + id;
        return ConfirmationDialog.open(type, imageType, shell, UIUtils.formatMessage(bundle.getString(titleKey), args), UIUtils.formatMessage(bundle.getString(messageKey), args), UIUtils.formatMessage(bundle.getString(toggleKey), args), false, prefKey);
    }

    public static String getResourceKey(String id, String key) {
        return RES_CONFIRM_PREFIX + id + "_" + key;
    }
}

