/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class StringInlineEditor
extends BaseValueEditor<Text> {
    private static final int MAX_STRING_LENGTH = 65535;

    public StringInlineEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected Text createControl(Composite editPlaceholder) {
        boolean inline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        Text editor = new Text(this.valueController.getEditPlaceholder(), inline ? 2048 : 578);
        editor.setTextLimit(65535);
        editor.setEditable(!this.valueController.isReadOnly());
        return editor;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        String strValue = this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.EDIT);
        ((Text)this.control).setText(strValue);
        if (this.valueController.getEditType() == IValueController.EditType.INLINE) {
            ((Text)this.control).selectAll();
        }
    }

    @Override
    public Object extractEditorValue() throws DBCException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DBCSession session = this.valueController.getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make string value from editor");){
            return this.valueController.getValueHandler().getValueFromObject(session, this.valueController.getValueType(), (Object)((Text)this.control).getText(), false);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

