/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.util.Date;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTimeEditor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.dialogs.data.ValueViewDialog;

public class DateTimeStandaloneEditor
extends ValueViewDialog {
    private CustomTimeEditor timeEditor;
    private boolean dirty;

    public DateTimeStandaloneEditor(IValueController valueController) {
        super(valueController);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        IValueController valueController = this.getValueController();
        Object value = valueController.getValue();
        Composite dialogGroup = (Composite)super.createDialogArea(parent);
        Composite panel = UIUtils.createPlaceholder(dialogGroup, 3);
        panel.setLayoutData((Object)new GridData(768));
        int style = 2048;
        if (valueController.isReadOnly()) {
            style |= 8;
        }
        UIUtils.createControlLabel(panel, "Time").setLayoutData((Object)new GridData(2));
        this.timeEditor = new CustomTimeEditor(panel, style);
        this.timeEditor.getControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DateTimeStandaloneEditor.this.dirty = true;
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 2;
        this.timeEditor.getControl().setLayoutData((Object)gd);
        this.primeEditorValue(value);
        Button button = UIUtils.createPushButton(panel, "Set Current", null);
        button.setLayoutData((Object)new GridData(128));
        button.setEnabled(!valueController.isReadOnly());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeStandaloneEditor.this.primeEditorValue(new Date());
            }
        });
        return dialogGroup;
    }

    @Override
    public Object extractEditorValue() throws DBException {
        String strValue = this.timeEditor.getValue();
        return this.getValueController().getValueHandler().getValueFromObject(null, this.getValueController().getValueType(), (Object)strValue, false);
    }

    @Override
    public void primeEditorValue(@Nullable Object value) {
        String strValue = value == null ? "" : this.getValueController().getValueHandler().getValueDisplayString(this.getValueController().getValueType(), value, DBDDisplayFormat.EDIT);
        this.timeEditor.setValue(strValue);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public Control getControl() {
        return null;
    }
}

