/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.valuefilter;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.GenericFilterValueEdit;

public class FilterValueEditPopup
extends Dialog {
    private static final String DIALOG_ID = "DBeaver.FilterValueEditMenu";
    private Object value;
    private GenericFilterValueEdit filter;
    private Point location;

    public FilterValueEditPopup(Shell parentShell, @NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attr, @NotNull ResultSetRow[] rows) {
        super(parentShell);
        this.setShellStyle(1264);
        this.filter = new GenericFilterValueEdit(viewer, attr, rows, DBCLogicalOperator.IN);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.location != null) {
            return this.location;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Filter by column value");
        Composite group = (Composite)super.createDialogArea(parent);
        UIUtils.createControlLabel(group, "Choose value(s) to filter by");
        Composite tableComposite = new Composite(group, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        tableComposite.setLayoutData((Object)gd);
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        this.filter.setupTable(tableComposite, 2580, true, false, new GridData(1808));
        Table table = this.filter.table.getTable();
        TableViewerColumn resultsetColumn = new TableViewerColumn(this.filter.table, 0);
        resultsetColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((FilterValueEditPopup)FilterValueEditPopup.this).filter.attr.getValueHandler().getValueDisplayString((DBSTypedObject)((FilterValueEditPopup)FilterValueEditPopup.this).filter.attr, ((DBDLabelValuePair)element).getValue(), DBDDisplayFormat.UI);
            }
        });
        resultsetColumn.getColumn().setResizable(false);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        resultsetColumn.getColumn().pack();
        int resultsetWidth = resultsetColumn.getColumn().getWidth();
        tableLayout.setColumnData((Widget)resultsetColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, resultsetWidth));
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DBeaverUI.asyncExec(() -> {
                    if (!UIUtils.isParent((Control)FilterValueEditPopup.this.getShell(), FilterValueEditPopup.this.getShell().getDisplay().getFocusControl())) {
                        FilterValueEditPopup.this.cancelPressed();
                    }
                });
            }
        };
        table.addFocusListener((FocusListener)focusListener);
        this.filter.table.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.value = ((IStructuredSelection)selection).getFirstElement();
            }
        });
        this.filter.table.addDoubleClickListener(event -> {
            this.value = this.filter.table.getStructuredSelection().getFirstElement();
            this.okPressed();
        });
        if (this.filter.attr.getDataKind() == DBPDataKind.STRING) {
            Text filterTextbox = this.filter.addFilterTextbox(group);
            filterTextbox.setFocus();
            filterTextbox.addTraverseListener(e -> {
                if (e.detail == 32 || e.detail == 64) {
                    if (table.getSelectionIndex() < 0 && table.getItemCount() > 0) {
                        table.setSelection(0);
                    }
                    table.setFocus();
                }
            });
            filterTextbox.addFocusListener((FocusListener)focusListener);
        } else {
            table.setFocus();
        }
        this.filter.filterPattern = null;
        this.filter.loadValues();
        return tableComposite;
    }

    protected Control createButtonBar(Composite parent) {
        return UIUtils.createPlaceholder(parent, 1);
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Object getValue() {
        return ((DBDLabelValuePair)this.value).getValue();
    }
}

