/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;

class ColorSettingsDialog
extends HelpEnabledDialog {
    private static final String DIALOG_ID = "DBeaver.ColorSettingsDialog";
    private final ResultSetViewer resultSetViewer;
    @Nullable
    private final List<DBDAttributeBinding> attributes;
    @Nullable
    private final ResultSetRow row;
    private CheckboxTableViewer colorsViewer;

    public ColorSettingsDialog(ResultSetViewer resultSetViewer, @Nullable DBDAttributeBinding attr, @Nullable ResultSetRow row) {
        super(resultSetViewer.getControl().getShell(), "row-colors");
        this.resultSetViewer = resultSetViewer;
        this.attributes = Arrays.asList(resultSetViewer.getModel().getAttributes());
        this.row = row;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Customize row coloring");
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite mainGroup = new Composite(composite, 0);
        mainGroup.setLayoutData((Object)new GridData(1810));
        mainGroup.setLayout((Layout)new GridLayout(2, false));
        Group colorsGroup = new Group(mainGroup, 0);
        colorsGroup.setText("Colors");
        colorsGroup.setLayoutData((Object)new GridData(1810));
        colorsGroup.setLayout((Layout)new GridLayout(1, false));
        this.colorsViewer = CheckboxTableViewer.newCheckList((Composite)colorsGroup, (int)2052);
        this.colorsViewer.getTable().setLayoutData((Object)new GridData(1808));
        ToolBar toolbar = new ToolBar((Composite)colorsGroup, 0x800100);
        ToolItem newButton = new ToolItem(toolbar, 0);
        newButton.setText("Add");
        newButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD));
        ToolItem deleteButton = new ToolItem(toolbar, 0);
        deleteButton.setText("Delete");
        deleteButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE));
        Group settingsGroup = new Group(mainGroup, 0);
        settingsGroup.setText("Settings");
        settingsGroup.setLayoutData((Object)new GridData(1810));
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        UIUtils.createLabelText((Composite)settingsGroup, "Title", "");
        UIUtils.createLabelCombo((Composite)settingsGroup, "Attribute", 12);
        UIUtils.createLabelCombo((Composite)settingsGroup, "Criteria", 12);
        UIUtils.createLabelText((Composite)settingsGroup, "Value", "");
        UIUtils.createControlLabel((Composite)settingsGroup, "Foreground");
        new ColorSelector((Composite)settingsGroup);
        UIUtils.createControlLabel((Composite)settingsGroup, "Background");
        new ColorSelector((Composite)settingsGroup);
        return parent;
    }

    private void refreshData() {
        this.colorsViewer.refresh();
    }

    public int open() {
        return super.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 7, CoreMessages.controls_resultset_filter_button_reset, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        super.okPressed();
    }
}

