/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.querylog;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.qm.DefaultEventFilter;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.TableToolTip;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TableColumnSortListener;
import org.jkiss.dbeaver.ui.dialogs.sql.BaseSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class QueryLogViewer
extends Viewer
implements QMMetaListener,
DBPPreferenceListener {
    private static final Log log = Log.getLog(QueryLogViewer.class);
    private static final String QUERY_LOG_CONTROL_ID = "org.jkiss.dbeaver.ui.qm.log";
    private static final String VIEWER_ID = "DBeaver.QM.LogViewer";
    private static final int MIN_ENTRIES_PER_PAGE = 1;
    public static final RGB COLOR_LIGHT_GREEN = new RGB(189, 254, 191);
    public static final RGB COLOR_LIGHT_RED = new RGB(255, 99, 71);
    public static final RGB COLOR_LIGHT_YELLOW = new RGB(255, 228, 181);
    public static final RGB COLOR_BLACK = new RGB(0, 0, 0);
    private LogColumn COLUMN_TIME = new LogColumn("time", CoreMessages.controls_querylog_column_time_name, CoreMessages.controls_querylog_column_time_tooltip, 80){
        private final DateFormat timeFormat;
        private final DateFormat timestampFormat;
        {
            this.timeFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
            this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
        }

        @Override
        String getText(QMMetaEvent event) {
            return this.timeFormat.format(event.getObject().getOpenTime());
        }

        @Override
        String getToolTipText(QMMetaEvent event) {
            return this.timestampFormat.format(event.getObject().getOpenTime());
        }
    };
    private static LogColumn COLUMN_TYPE = new LogColumn("type", CoreMessages.controls_querylog_column_type_name, CoreMessages.controls_querylog_column_type_tooltip, 100){

        @Override
        String getText(QMMetaEvent event) {
            return QueryLogViewer.getObjectType(event.getObject());
        }
    };
    private static LogColumn COLUMN_TEXT = new LogColumn("text", CoreMessages.controls_querylog_column_text_name, CoreMessages.controls_querylog_column_text_tooltip, 400){

        @Override
        String getText(QMMetaEvent event) {
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo) {
                QMMStatementExecuteInfo statement = (QMMStatementExecuteInfo)object;
                return CommonUtils.truncateString((String)statement.getQueryString(), (int)4000);
            }
            if (object instanceof QMMTransactionInfo) {
                if (((QMMTransactionInfo)object).isCommitted()) {
                    return CoreMessages.controls_querylog_commit;
                }
                return CoreMessages.controls_querylog_rollback;
            }
            if (object instanceof QMMTransactionSavepointInfo) {
                if (((QMMTransactionSavepointInfo)object).isCommitted()) {
                    return CoreMessages.controls_querylog_commit;
                }
                return CoreMessages.controls_querylog_rollback;
            }
            if (object instanceof QMMSessionInfo) {
                String containerName = ((QMMSessionInfo)object).getContainerName();
                switch (event.getAction()) {
                    case BEGIN: {
                        return String.valueOf(CoreMessages.controls_querylog_connected_to) + containerName + "\"";
                    }
                    case END: {
                        return String.valueOf(CoreMessages.controls_querylog_disconnected_from) + containerName + "\"";
                    }
                }
                return "?";
            }
            return "";
        }
    };
    private static LogColumn COLUMN_DURATION = new LogColumn("duration", CoreMessages.controls_querylog_column_duration_name, CoreMessages.controls_querylog_column_duration_tooltip, 100){

        @Override
        String getText(QMMetaEvent event) {
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo) {
                QMMStatementExecuteInfo exec = (QMMStatementExecuteInfo)object;
                if (exec.isClosed()) {
                    long execTime = exec.getCloseTime() - exec.getOpenTime();
                    long fetchTime = exec.isFetching() ? 0L : exec.getFetchEndTime() - exec.getFetchBeginTime();
                    return String.valueOf(String.valueOf(execTime + fetchTime)) + CoreMessages.controls_querylog__ms;
                }
                return "";
            }
            if (object instanceof QMMTransactionInfo) {
                QMMTransactionInfo txn = (QMMTransactionInfo)object;
                if (txn.isClosed()) {
                    return QueryLogViewer.formatMinutes(txn.getCloseTime() - txn.getOpenTime());
                }
                return "";
            }
            if (object instanceof QMMTransactionSavepointInfo) {
                QMMTransactionSavepointInfo sp = (QMMTransactionSavepointInfo)object;
                if (sp.isClosed()) {
                    return QueryLogViewer.formatMinutes(sp.getCloseTime() - sp.getOpenTime());
                }
                return "";
            }
            if (object instanceof QMMSessionInfo) {
                QMMSessionInfo session = (QMMSessionInfo)object;
                if (session.isClosed()) {
                    return QueryLogViewer.formatMinutes(session.getCloseTime() - session.getOpenTime());
                }
                return "";
            }
            return "";
        }
    };
    private static LogColumn COLUMN_ROWS = new LogColumn("rows", CoreMessages.controls_querylog_column_rows_name, CoreMessages.controls_querylog_column_rows_tooltip, 120){

        @Override
        String getText(QMMetaEvent event) {
            QMMStatementExecuteInfo exec;
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo && (exec = (QMMStatementExecuteInfo)object).isClosed() && !exec.isFetching()) {
                long rowCount = exec.getRowCount();
                if (rowCount < 0L) {
                    return "";
                }
                return String.valueOf(rowCount);
            }
            return "";
        }
    };
    private static LogColumn COLUMN_RESULT = new LogColumn("result", CoreMessages.controls_querylog_column_result_name, CoreMessages.controls_querylog_column_result_tooltip, 120){

        @Override
        String getText(QMMetaEvent event) {
            QMMStatementExecuteInfo exec;
            if (event.getObject() instanceof QMMStatementExecuteInfo && (exec = (QMMStatementExecuteInfo)event.getObject()).isClosed()) {
                if (exec.hasError()) {
                    if (exec.getErrorCode() == 0) {
                        return exec.getErrorMessage();
                    }
                    if (exec.getErrorMessage() == null) {
                        return String.valueOf(CoreMessages.controls_querylog_error) + exec.getErrorCode() + "]";
                    }
                    return "[" + exec.getErrorCode() + "] " + exec.getErrorMessage();
                }
                return CoreMessages.controls_querylog_success;
            }
            return "";
        }
    };
    private static LogColumn COLUMN_DATA_SOURCE = new LogColumn("datasource", CoreMessages.controls_querylog_column_connection_name, CoreMessages.controls_querylog_column_connection_tooltip, 150){

        @Override
        String getText(QMMetaEvent event) {
            QMMObject object = event.getObject();
            String containerName = null;
            if (object instanceof QMMSessionInfo) {
                containerName = ((QMMSessionInfo)object).getContainerName();
            } else if (object instanceof QMMTransactionInfo) {
                containerName = ((QMMTransactionInfo)object).getSession().getContainerName();
            } else if (object instanceof QMMTransactionSavepointInfo) {
                containerName = ((QMMTransactionSavepointInfo)object).getTransaction().getSession().getContainerName();
            } else if (object instanceof QMMStatementInfo) {
                containerName = ((QMMStatementInfo)object).getSession().getContainerName();
            } else if (object instanceof QMMStatementExecuteInfo) {
                containerName = ((QMMStatementExecuteInfo)object).getStatement().getSession().getContainerName();
            }
            return containerName == null ? "?" : containerName;
        }
    };
    private static LogColumn COLUMN_CONTEXT = new LogColumn("context", CoreMessages.controls_querylog_column_context_name, CoreMessages.controls_querylog_column_context_tooltip, 150){

        @Override
        String getText(QMMetaEvent event) {
            QMMObject object = event.getObject();
            String contextName = null;
            if (object instanceof QMMSessionInfo) {
                contextName = ((QMMSessionInfo)object).getContextName();
            } else if (object instanceof QMMTransactionInfo) {
                contextName = ((QMMTransactionInfo)object).getSession().getContextName();
            } else if (object instanceof QMMTransactionSavepointInfo) {
                contextName = ((QMMTransactionSavepointInfo)object).getTransaction().getSession().getContextName();
            } else if (object instanceof QMMStatementInfo) {
                contextName = ((QMMStatementInfo)object).getSession().getContextName();
            } else if (object instanceof QMMStatementExecuteInfo) {
                contextName = ((QMMStatementExecuteInfo)object).getStatement().getSession().getContextName();
            }
            if (contextName == null) {
                return "?";
            }
            return contextName;
        }
    };
    private LogColumn[] ALL_COLUMNS = new LogColumn[]{this.COLUMN_TIME, COLUMN_TYPE, COLUMN_TEXT, COLUMN_DURATION, COLUMN_ROWS, COLUMN_RESULT, COLUMN_DATA_SOURCE, COLUMN_CONTEXT};
    private final IWorkbenchPartSite site;
    private Table logTable;
    private List<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
    private LongKeyMap<TableItem> objectToItemMap = new LongKeyMap();
    private QMEventFilter defaultFilter = new DefaultEventFilter();
    private QMEventFilter filter;
    private boolean useDefaultFilter = true;
    private final Color colorLightGreen;
    private final Color colorLightRed;
    private final Color colorLightYellow;
    private final Color colorGray;
    private final Font boldFont;
    private DragSource dndSource;
    private int entriesPerPage = 1;
    private ConfigRefreshJob configRefreshJob = null;

    public QueryLogViewer(Composite parent, IWorkbenchPartSite site, QMEventFilter filter, boolean showConnection) {
        this.site = site;
        SharedTextColors sharedColors = DBeaverUI.getSharedTextColors();
        this.colorLightGreen = sharedColors.getColor(COLOR_LIGHT_GREEN);
        this.colorLightRed = sharedColors.getColor(COLOR_LIGHT_RED);
        this.colorLightYellow = sharedColors.getColor(COLOR_LIGHT_YELLOW);
        this.colorGray = sharedColors.getColor(COLOR_BLACK);
        this.boldFont = UIUtils.makeBoldFont(parent.getFont());
        boolean inDialog = UIUtils.isInDialog((Control)parent);
        this.logTable = new Table(parent, 0x10302 | (inDialog ? 2048 : 0));
        this.logTable.setData((Object)this);
        this.logTable.setLinesVisible(true);
        this.logTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        this.logTable.setLayoutData((Object)gd);
        new TableToolTip(this.logTable){

            @Override
            public String getItemToolTip(TableItem item, int selectedColumn) {
                LogColumn column = (LogColumn)QueryLogViewer.this.logTable.getColumn(selectedColumn).getData();
                return column.getToolTipText((QMMetaEvent)item.getData());
            }
        };
        this.createColumns(showConnection);
        UIUtils.addFocusTracker((IServiceLocator)site, QUERY_LOG_CONTROL_ID, (Control)this.logTable);
        this.logTable.addDisposeListener(e -> {
            UIUtils.removeFocusTracker((IServiceLocator)this.site, (Control)this.logTable);
            this.dispose();
        });
        this.createContextMenu();
        this.addDragAndDropSupport();
        this.logTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                QueryLogViewer.this.showEventDetails((QMMetaEvent)e.item.getData());
            }
        });
        this.filter = filter;
        this.reloadEvents();
        DBeaverCore.getInstance();
        QMUtils.registerMetaListener((QMMetaListener)this);
        DBeaverCore.getGlobalPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
    }

    public void setFilter(QMEventFilter filter) {
        this.filter = filter;
    }

    public void setUseDefaultFilter(boolean useDefaultFilter) {
        this.useDefaultFilter = useDefaultFilter;
    }

    private void showEventDetails(QMMetaEvent event) {
        EventViewDialog dialog = new EventViewDialog(event);
        dialog.open();
    }

    private void createColumns(boolean showConnection) {
        TableColumn[] tableColumnArray = this.logTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.dispose();
            ++n2;
        }
        this.columns.clear();
        IDialogSettings dialogSettings = UIUtils.getDialogSettings(VIEWER_ID);
        int colIndex = 0;
        LogColumn[] logColumnArray = this.ALL_COLUMNS;
        int n3 = this.ALL_COLUMNS.length;
        int n4 = 0;
        while (n4 < n3) {
            LogColumn logColumn = logColumnArray[n4];
            if (showConnection || logColumn != COLUMN_DATA_SOURCE && logColumn != COLUMN_CONTEXT) {
                TableColumn tableColumn = UIUtils.createTableColumn(this.logTable, 0, logColumn.title);
                tableColumn.setData((Object)logColumn);
                String colWidth = dialogSettings.get("column-" + logColumn.id);
                if (colWidth != null) {
                    tableColumn.setWidth(Integer.parseInt(colWidth));
                } else {
                    tableColumn.setWidth(logColumn.widthHint);
                }
                tableColumn.setToolTipText(logColumn.toolTip);
                ColumnDescriptor cd = new ColumnDescriptor(logColumn, tableColumn);
                this.columns.add(cd);
                tableColumn.addListener(13, (Listener)new TableColumnSortListener(this.logTable, colIndex));
                tableColumn.addListener(11, event -> {
                    int width = tableColumn.getWidth();
                    dialogSettings.put("column-" + logColumn.id, String.valueOf(width));
                });
                ++colIndex;
            }
            ++n4;
        }
    }

    private void dispose() {
        DBeaverCore.getGlobalPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
        QMUtils.unregisterMetaListener((QMMetaListener)this);
        UIUtils.dispose((Widget)this.dndSource);
        UIUtils.dispose((Widget)this.logTable);
        UIUtils.dispose((Resource)this.boldFont);
    }

    public Table getControl() {
        return this.logTable;
    }

    public Object getInput() {
        return null;
    }

    public void setInput(Object input) {
    }

    public IStructuredSelection getSelection() {
        TableItem[] items = this.logTable.getSelection();
        Object[] data = new QMMetaEvent[items.length];
        int i = 0;
        int itemsLength = items.length;
        while (i < itemsLength) {
            data[i] = (QMMetaEvent)items[i].getData();
            ++i;
        }
        return new StructuredSelection(data);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void refresh() {
        this.reloadEvents();
    }

    private static String getObjectType(QMMObject object) {
        if (object instanceof QMMSessionInfo) {
            return CoreMessages.model_navigator_Connection;
        }
        if (object instanceof QMMStatementInfo || object instanceof QMMStatementExecuteInfo) {
            QMMStatementInfo statement = object instanceof QMMStatementInfo ? (QMMStatementInfo)object : ((QMMStatementExecuteInfo)object).getStatement();
            return "SQL" + (statement == null ? "" : " / " + statement.getPurpose().name());
        }
        if (object instanceof QMMTransactionInfo) {
            return CoreMessages.controls_querylog_transaction;
        }
        if (object instanceof QMMTransactionSavepointInfo) {
            return CoreMessages.controls_querylog_savepoint;
        }
        return "";
    }

    private Font getObjectFont(QMMetaEvent event) {
        QMMStatementExecuteInfo exec;
        if (event.getObject() instanceof QMMStatementExecuteInfo && (!(exec = (QMMStatementExecuteInfo)event.getObject()).isClosed() || exec.isFetching())) {
            return this.boldFont;
        }
        return null;
    }

    private Color getObjectForeground(QMMetaEvent event) {
        if (this.getObjectBackground(event) != null) {
            return this.colorGray;
        }
        return null;
    }

    private Color getObjectBackground(QMMetaEvent event) {
        if (event.getObject() instanceof QMMStatementExecuteInfo) {
            QMMStatementExecuteInfo exec = (QMMStatementExecuteInfo)event.getObject();
            if (exec.hasError()) {
                return this.colorLightRed;
            }
            QMMTransactionSavepointInfo savepoint = exec.getSavepoint();
            if (savepoint == null) {
                return this.colorLightGreen;
            }
            if (savepoint.isClosed()) {
                return savepoint.isCommitted() ? this.colorLightGreen : this.colorLightYellow;
            }
            return null;
        }
        if (event.getObject() instanceof QMMTransactionInfo || event.getObject() instanceof QMMTransactionSavepointInfo) {
            QMMTransactionSavepointInfo savepoint = event.getObject() instanceof QMMTransactionInfo ? ((QMMTransactionInfo)event.getObject()).getCurrentSavepoint() : (QMMTransactionSavepointInfo)event.getObject();
            return savepoint.isCommitted() ? this.colorLightGreen : this.colorLightYellow;
        }
        return null;
    }

    private void reloadEvents() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        this.entriesPerPage = Math.max(1, store.getInt("qm.maxEntries"));
        this.defaultFilter = new DefaultEventFilter();
        this.clearLog();
        this.updateMetaInfo(QMUtils.getPastMetaEvents());
    }

    public void metaInfoChanged(@NotNull List<QMMetaEvent> events) {
        if (DBeaverCore.isClosing()) {
            return;
        }
        DBeaverUI.asyncExec(() -> this.updateMetaInfo(events));
    }

    private synchronized void updateMetaInfo(List<QMMetaEvent> events) {
        if (this.logTable.isDisposed()) {
            return;
        }
        this.logTable.setRedraw(false);
        try {
            try {
                int itemIndex = 0;
                int i = events.size();
                while (i > 0) {
                    if (this.useDefaultFilter && itemIndex >= this.entriesPerPage) break;
                    QMMetaEvent event = events.get(i - 1);
                    if (!(this.filter != null && !this.filter.accept(event) || this.useDefaultFilter && !this.defaultFilter.accept(event))) {
                        QMMetaEvent.Action action;
                        QMMObject object = event.getObject();
                        if (object instanceof QMMStatementExecuteInfo) {
                            itemIndex = this.createOrUpdateItem(event, itemIndex);
                        } else if (object instanceof QMMTransactionInfo || object instanceof QMMTransactionSavepointInfo) {
                            itemIndex = this.createOrUpdateItem(event, itemIndex);
                            if (object instanceof QMMTransactionInfo) {
                                QMMTransactionSavepointInfo savepoint = ((QMMTransactionInfo)object).getCurrentSavepoint();
                                while (savepoint != null) {
                                    this.updateExecutions(event, savepoint);
                                    savepoint = savepoint.getPrevious();
                                }
                            } else {
                                this.updateExecutions(event, (QMMTransactionSavepointInfo)object);
                            }
                        } else if (object instanceof QMMSessionInfo && ((action = event.getAction()) == QMMetaEvent.Action.BEGIN || action == QMMetaEvent.Action.END)) {
                            TableItem item = new TableItem(this.logTable, 0, itemIndex++);
                            this.updateItem(event, item);
                        }
                    }
                    --i;
                }
                int itemCount = this.logTable.getItemCount();
                if (itemCount > this.entriesPerPage) {
                    int[] indexes = new int[itemCount - this.entriesPerPage];
                    int i2 = 0;
                    while (i2 < itemCount - this.entriesPerPage) {
                        indexes[i2] = this.entriesPerPage + i2;
                        TableItem tableItem = this.logTable.getItem(this.entriesPerPage + i2);
                        if (tableItem != null && tableItem.getData() instanceof QMMObject) {
                            this.objectToItemMap.remove(((QMMObject)tableItem.getData()).getObjectId());
                        }
                        ++i2;
                    }
                    this.logTable.remove(indexes);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error updating Query Log", (Throwable)e);
                if (!this.logTable.isDisposed()) {
                    this.logTable.setRedraw(true);
                }
            }
        }
        finally {
            if (!this.logTable.isDisposed()) {
                this.logTable.setRedraw(true);
            }
        }
    }

    private void updateExecutions(QMMetaEvent event, QMMTransactionSavepointInfo savepoint) {
        Iterator i = savepoint.getExecutions();
        while (i.hasNext()) {
            TableItem item;
            QMMStatementExecuteInfo exec = (QMMStatementExecuteInfo)i.next();
            if (exec.hasError() || (item = (TableItem)this.objectToItemMap.get(exec.getObjectId())) == null || item.isDisposed()) continue;
            item.setFont(this.getObjectFont(event));
            item.setForeground(this.getObjectForeground(event));
            item.setBackground(this.getObjectBackground(event));
        }
    }

    private int createOrUpdateItem(QMMetaEvent event, int itemIndex) {
        TableItem item = (TableItem)this.objectToItemMap.get(event.getObject().getObjectId());
        if (item == null) {
            item = new TableItem(this.logTable, 0, itemIndex++);
            this.objectToItemMap.put(event.getObject().getObjectId(), (Object)item);
        }
        this.updateItem(event, item);
        return itemIndex;
    }

    private void updateItem(QMMetaEvent event, TableItem item) {
        item.setData((Object)event);
        int i = 0;
        int columnsSize = this.columns.size();
        while (i < columnsSize) {
            ColumnDescriptor cd = this.columns.get(i);
            item.setText(i, TextUtils.getSingleLineString(cd.logColumn.getText(event)));
            ++i;
        }
        item.setFont(this.getObjectFont(event));
        item.setForeground(this.getObjectForeground(event));
        item.setBackground(this.getObjectBackground(event));
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.logTable);
        menuMgr.addMenuListener(manager -> {
            Action editorAction = new Action("Open in SQL console", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE)){

                public void run() {
                    QueryLogViewer.this.openSelectionInEditor();
                }
            };
            Action copyAction = new Action(CoreMessages.controls_querylog_action_copy){

                public void run() {
                    QueryLogViewer.this.copySelectionToClipboard(false);
                }
            };
            copyAction.setEnabled(this.logTable.getSelectionCount() > 0);
            copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            Action copyAllAction = new Action(CoreMessages.controls_querylog_action_copy_all_fields){

                public void run() {
                    QueryLogViewer.this.copySelectionToClipboard(true);
                }
            };
            copyAllAction.setEnabled(this.logTable.getSelectionCount() > 0);
            copyAllAction.setActionDefinitionId("org.jkiss.dbeaver.core.edit.copy.special");
            Action selectAllAction = new Action(CoreMessages.controls_querylog_action_select_all){

                public void run() {
                    QueryLogViewer.this.selectAll();
                }
            };
            selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
            Action clearLogAction = new Action(CoreMessages.controls_querylog_action_clear_log){

                public void run() {
                    QueryLogViewer.this.clearLog();
                }
            };
            boolean hasStatements = false;
            TableItem[] tableItemArray = this.logTable.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (((QMMetaEvent)item.getData()).getObject() instanceof QMMStatementExecuteInfo) {
                    hasStatements = true;
                    break;
                }
                ++n2;
            }
            if (hasStatements) {
                manager.add((IAction)editorAction);
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)copyAction);
            manager.add((IAction)copyAllAction);
            manager.add((IAction)selectAllAction);
            manager.add((IAction)clearLogAction);
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.logTable.setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void openSelectionInEditor() {
        TableItem[] items;
        DataSourceDescriptor dsContainer = null;
        StringBuilder sql = new StringBuilder();
        TableItem[] tableItemArray = items = this.logTable.getSelection();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            QMMetaEvent event = (QMMetaEvent)item.getData();
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo) {
                String queryString;
                QMMStatementExecuteInfo stmtExec = (QMMStatementExecuteInfo)object;
                if (dsContainer == null) {
                    String containerId = stmtExec.getStatement().getSession().getContainerId();
                    dsContainer = DataSourceRegistry.findDataSource(containerId);
                }
                if (!CommonUtils.isEmptyTrimmed((String)(queryString = stmtExec.getQueryString()))) {
                    if (sql.length() > 0) {
                        sql.append("\n");
                    }
                    queryString = queryString.trim();
                    sql.append(queryString);
                    if (!queryString.endsWith(";")) {
                        sql.append(";").append("\n");
                    }
                }
            }
            ++n2;
        }
        if (sql.length() > 0) {
            OpenHandler.openSQLConsole(DBeaverUI.getActiveWorkbenchWindow(), dsContainer, "QueryManager", sql.toString());
        }
    }

    private void addDragAndDropSupport() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        this.dndSource = new DragSource((Control)this.logTable, operations);
        this.dndSource.setTransfer(types);
        this.dndSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                String tdt = QueryLogViewer.this.getSelectedText(false);
                event.data = !CommonUtils.isEmpty((String)tdt) ? tdt : "";
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    public synchronized void clearLog() {
        this.logTable.removeAll();
        this.objectToItemMap.clear();
    }

    public void selectAll() {
        if (!this.logTable.isDisposed()) {
            this.logTable.selectAll();
        }
    }

    public void copySelectionToClipboard(boolean extraInfo) {
        String tdt = this.getSelectedText(extraInfo);
        if (CommonUtils.isEmpty((String)tdt)) {
            return;
        }
        if (tdt.length() > 0) {
            UIUtils.setClipboardContents(this.logTable.getDisplay(), (Transfer)TextTransfer.getInstance(), tdt);
        }
    }

    private String getSelectedText(boolean extraInfo) {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        StringBuilder tdt = new StringBuilder();
        for (QMMetaEvent item : selection) {
            if (tdt.length() > 0) {
                tdt.append(GeneralUtils.getDefaultLineSeparator());
            }
            if (extraInfo) {
                int i1 = 0;
                int columnsSize = this.columns.size();
                while (i1 < columnsSize) {
                    ColumnDescriptor cd = this.columns.get(i1);
                    String text = cd.logColumn.getText(item);
                    if (i1 > 0) {
                        tdt.append('\t');
                    }
                    tdt.append(text);
                    ++i1;
                }
                continue;
            }
            String text = COLUMN_TEXT.getText(item);
            tdt.append(text);
        }
        return tdt.toString();
    }

    private static String formatMinutes(long ms) {
        long min = ms / 1000L / 60L;
        long sec = (ms - min * 1000L * 60L) / 1000L;
        return NLS.bind((String)CoreMessages.controls_querylog_format_minutes, (Object)String.valueOf(min), (Object)String.valueOf(sec));
    }

    public synchronized void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        if (event.getProperty().startsWith("qm.") && this.configRefreshJob == null) {
            this.configRefreshJob = new ConfigRefreshJob();
            this.configRefreshJob.schedule(250L);
            this.configRefreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    QueryLogViewer.this.configRefreshJob = null;
                }
            });
        }
    }

    private static class ColumnDescriptor {
        LogColumn logColumn;
        TableColumn tableColumn;

        ColumnDescriptor(LogColumn logColumn, TableColumn tableColumn) {
            this.logColumn = logColumn;
            this.tableColumn = tableColumn;
        }
    }

    private class ConfigRefreshJob
    extends AbstractUIJob {
        ConfigRefreshJob() {
            super(CoreMessages.controls_querylog_job_refresh);
        }

        @Override
        protected IStatus runInUIThread(DBRProgressMonitor monitor) {
            QueryLogViewer.this.reloadEvents();
            return Status.OK_STATUS;
        }
    }

    private class EventViewDialog
    extends BaseSQLDialog {
        private static final String DIALOG_ID = "DBeaver.QM.EventViewDialog";
        private final QMMetaEvent object;

        EventViewDialog(QMMetaEvent object) {
            super(QueryLogViewer.this.getControl().getShell(), QueryLogViewer.this.site, "Event", null);
            this.setShellStyle(1264);
            this.object = object;
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return UIUtils.getDialogSettings(DIALOG_ID);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(String.valueOf(CoreMessages.controls_querylog_shell_text) + COLUMN_TYPE.getText(this.object));
        }

        @Override
        protected Composite createDialogArea(Composite parent) {
            Composite msg;
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(1, false));
            Composite topFrame = UIUtils.createPlaceholder(composite, 2, 5);
            topFrame.setLayoutData((Object)new GridData(1808));
            UIUtils.createLabelText(topFrame, CoreMessages.controls_querylog_label_time, QueryLogViewer.this.COLUMN_TIME.getText(this.object), 8);
            UIUtils.createLabelText(topFrame, CoreMessages.controls_querylog_label_type, COLUMN_TYPE.getText(this.object), 2056);
            Label messageLabel = UIUtils.createControlLabel(topFrame, CoreMessages.controls_querylog_label_text);
            messageLabel.setLayoutData((Object)new GridData(2));
            if (this.object.getObject() instanceof QMMStatementExecuteInfo) {
                msg = this.createSQLPanel(topFrame);
            } else {
                Text messageText = new Text(topFrame, 2634);
                messageText.setText(COLUMN_TEXT.getText(this.object));
                msg = messageText;
            }
            GridData gd = new GridData(1808);
            gd.widthHint = 500;
            msg.setLayoutData((Object)gd);
            Composite bottomFrame = UIUtils.createPlaceholder(composite, 1, 5);
            bottomFrame.setLayoutData((Object)new GridData(768));
            Label resultLabel = UIUtils.createControlLabel(bottomFrame, CoreMessages.controls_querylog_label_result);
            resultLabel.setLayoutData((Object)new GridData(2));
            Text resultText = new Text(bottomFrame, 2890);
            resultText.setText(COLUMN_RESULT.getText(this.object));
            gd = new GridData(768);
            gd.heightHint = 60;
            gd.widthHint = 300;
            resultText.setLayoutData((Object)gd);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        @Override
        protected SQLDialect getSQLDialect() {
            if (this.object.getObject() instanceof QMMStatementExecuteInfo) {
                return ((QMMStatementExecuteInfo)this.object.getObject()).getStatement().getSession().getSQLDialect();
            }
            return super.getSQLDialect();
        }

        @Override
        protected DBCExecutionContext getExecutionContext() {
            return null;
        }

        @Override
        protected String getSQLText() {
            return COLUMN_TEXT.getText(this.object);
        }

        @Override
        protected boolean isLabelVisible() {
            return false;
        }
    }

    private static abstract class LogColumn {
        private final String id;
        private final String title;
        private final String toolTip;
        private final int widthHint;

        private LogColumn(String id, String title, String toolTip, int widthHint) {
            this.id = id;
            this.title = title;
            this.toolTip = toolTip;
            this.widthHint = widthHint;
        }

        abstract String getText(QMMetaEvent var1);

        String getToolTipText(QMMetaEvent event) {
            return this.getText(event);
        }
    }
}

