/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;

public class ObjectEditorPageControl
extends ProgressPageControl {
    private IDatabaseEditor workbenchPart;
    private IPropertyListener propertyListener;

    public ObjectEditorPageControl(Composite parent, int style, IDatabaseEditor workbenchPart) {
        super(parent, style);
        this.workbenchPart = workbenchPart;
    }

    @Override
    public void disposeControl() {
        if (this.propertyListener != null) {
            this.getMainEditorPart().removePropertyListener(this.propertyListener);
            this.propertyListener = null;
        }
        super.disposeControl();
    }

    public IDatabaseEditor getEditorPart() {
        return this.workbenchPart;
    }

    public boolean isObjectEditable() {
        DBCExecutionContext context = this.getEditorPart().getEditorInput().getExecutionContext();
        if (context == null) {
            return false;
        }
        if (context.getDataSource().getInfo().isReadOnlyMetaData()) {
            return false;
        }
        DBSObject databaseObject = this.getEditorPart().getEditorInput().getDatabaseObject();
        return databaseObject != null && EntityEditorsRegistry.getInstance().getObjectManager(databaseObject.getClass(), DBEObjectManager.class) != null;
    }

    private IEditorPart getMainEditorPart() {
        IWorkbenchPartSite site = this.workbenchPart.getSite();
        if (site instanceof MultiPageEditorSite) {
            return ((MultiPageEditorSite)site).getMultiPageEditor();
        }
        return this.workbenchPart;
    }

    @Override
    protected void fillCustomActions(IContributionManager contributionManager) {
        super.fillCustomActions(contributionManager);
    }
}

