/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class CustomTreeEditor
implements MouseListener,
TraverseListener {
    private final Tree tree;
    private final TreeEditor treeEditor;
    private int columnIndex;
    protected int firstTraverseIndex = -1;
    protected int lastTraverseIndex = -1;

    public CustomTreeEditor(Tree tree) {
        this.tree = tree;
        this.treeEditor = new TreeEditor(tree);
        this.treeEditor.horizontalAlignment = 0x1000000;
        this.treeEditor.verticalAlignment = 128;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.minimumWidth = 50;
        tree.addMouseListener((MouseListener)this);
        tree.addTraverseListener((TraverseListener)this);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        final TreeItem item = this.tree.getItem(new Point(e.x, e.y));
        if (item != null) {
            this.columnIndex = UIUtils.getColumnAtPos(item, e.x, e.y);
            DBeaverUI.asyncExec(new Runnable(){

                @Override
                public void run() {
                    CustomTreeEditor.this.showEditor(item);
                }
            });
        }
    }

    public void showEditor(TreeItem item) {
        this.closeEditor();
        this.tree.showItem(item);
        final Control editor = this.createEditor(this.tree, this.columnIndex, item);
        if (editor == null) {
            return;
        }
        editor.setFocus();
        editor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomTreeEditor.this.saveEditorValue(editor, CustomTreeEditor.this.columnIndex, CustomTreeEditor.this.treeEditor.getItem());
                CustomTreeEditor.this.closeEditor();
            }
        });
        editor.addTraverseListener((TraverseListener)this);
        this.treeEditor.setEditor(editor, item, this.columnIndex);
    }

    public void closeEditor() {
        Control oldEditor = this.treeEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    public void keyTraversed(TraverseEvent e) {
        Control editor = this.treeEditor.getEditor();
        if (editor != null && editor.isDisposed()) {
            editor = null;
        }
        if (e.detail == 4) {
            if (editor != null) {
                this.saveEditorValue(editor, this.columnIndex, this.treeEditor.getItem());
                this.closeEditor();
            } else {
                TreeItem[] selection = this.tree.getSelection();
                if (selection != null && selection.length >= 1) {
                    this.showEditor(selection[0]);
                }
            }
            e.doit = false;
            e.detail = 0;
        } else if (e.detail == 16 && editor != null) {
            TreeItem item = this.treeEditor.getItem();
            if (item != null) {
                int lastColumn;
                this.saveEditorValue(editor, this.columnIndex, item);
                this.closeEditor();
                int n = lastColumn = this.lastTraverseIndex > 0 ? this.lastTraverseIndex : this.tree.getColumnCount() - 1;
                if (this.columnIndex < lastColumn) {
                    ++this.columnIndex;
                } else {
                    item = UIUtils.getNextTreeItem(this.tree, this.treeEditor.getItem());
                    if (item == null && this.tree.getItemCount() > 0) {
                        item = this.tree.getItem(0);
                    }
                    if (item != null) {
                        this.columnIndex = this.firstTraverseIndex > 0 ? this.firstTraverseIndex : 0;
                    } else {
                        return;
                    }
                }
                this.showEditor(item);
                this.tree.setSelection(item);
                e.doit = false;
                e.detail = 0;
            }
        } else if (e.detail == 2 && editor != null) {
            this.closeEditor();
            e.doit = false;
            e.detail = 0;
        }
    }

    protected abstract Control createEditor(Tree var1, int var2, TreeItem var3);

    protected abstract void saveEditorValue(Control var1, int var2, TreeItem var3);
}

