/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.navigator;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectRename
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structSelection;
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DBNNode) {
            NavigatorHandlerObjectRename.renameNode(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), (DBNNode)element, null);
        }
        return null;
    }

    public static boolean renameNode(IWorkbenchWindow workbenchWindow, DBNNode node, String newName) {
        if (newName == null) {
            newName = EnterNameDialog.chooseName(workbenchWindow.getShell(), "Rename " + node.getNodeType(), node.getNodeName());
        }
        if (CommonUtils.isEmpty((String)newName) || newName.equals(node.getNodeName())) {
            return false;
        }
        if (node.supportsRename()) {
            try {
                node.rename((DBRProgressMonitor)new VoidProgressMonitor(), newName);
                return true;
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Rename", "Can't rename object '" + node.getNodeName() + "'", (Throwable)e);
            }
        }
        if (node instanceof DBNDatabaseNode) {
            return NavigatorHandlerObjectRename.renameDatabaseObject(workbenchWindow, (DBNDatabaseNode)node, newName);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean renameDatabaseObject(IWorkbenchWindow workbenchWindow, DBNDatabaseNode node, String newName) {
        try {
            if (!(node.getParentNode() instanceof DBNContainer)) return false;
            DBNContainer container = (DBNContainer)node.getParentNode();
            DBSObject object = node.getObject();
            if (object == null) return false;
            DBEObjectRenamer objectRenamer = EntityEditorsRegistry.getInstance().getObjectManager(object.getClass(), DBEObjectRenamer.class);
            if (objectRenamer == null) return false;
            NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectRename.getCommandTarget(workbenchWindow, container, object.getClass(), false);
            objectRenamer.renameObject(commandTarget.getContext(), object, newName);
            if (object.isPersisted() && commandTarget.getEditor() == null) {
                Map options = DBPScriptObject.EMPTY_OPTIONS;
                if (!NavigatorHandlerObjectRename.showScript(workbenchWindow, commandTarget.getContext(), options, "Rename script")) {
                    commandTarget.getContext().resetChanges();
                    return false;
                }
                NavigatorHandlerObjectBase.ObjectSaver renamer = new NavigatorHandlerObjectBase.ObjectSaver(commandTarget.getContext(), options);
                TasksJob.runTask("Rename object '" + object.getName() + "'", renamer);
                return true;
            }
            Iterator iterator = commandTarget.getContext().getFinalCommands().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                DBECommand dBECommand = (DBECommand)iterator.next();
            }
        }
        catch (Throwable e) {
            DBUserInterface.getInstance().showError("Rename object", "Can't rename object '" + node.getNodeName() + "'", e);
            return false;
        }
    }
}

