/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceTransactionModeContributor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ToolsContextMenuHandler
extends AbstractDataSourceHandler {
    private MenuManager menuManager = new MenuManager();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (part == null || activeShell == null) {
            return null;
        }
        Control focusControl = activeShell.getDisplay().getFocusControl();
        if (focusControl == null) {
            return null;
        }
        Point location = this.getLocationFromControl(activeShell, focusControl);
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        this.menuManager = new MenuManager();
        this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), "org.jkiss.dbeaver.core.connect"));
        this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), "org.jkiss.dbeaver.core.disconnect"));
        this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), "org.jkiss.dbeaver.core.invalidate"));
        if (part instanceof IEditorPart) {
            this.menuManager.add((IContributionItem)new Separator());
            this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), "org.jkiss.dbeaver.core.commit"));
            this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), "org.jkiss.dbeaver.core.rollback"));
            MenuManager txnMenu = new MenuManager(DBeaverActivator.getPluginResourceBundle().getString("command.org.jkiss.dbeaver.core.transaction_mode.name"));
            txnMenu.add((IContributionItem)new DataSourceTransactionModeContributor());
            this.menuManager.add((IContributionItem)txnMenu);
        }
        this.menuManager.add((IContributionItem)new Separator());
        this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), "org.jkiss.dbeaver.core.sql.editor.open"));
        if (part instanceof IEditorPart) {
            this.menuManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)part.getSite(), "org.jkiss.dbeaver.core.navigator.linkeditor", "Find in navigator", null));
        }
        final Menu contextMenu = this.menuManager.createContextMenu(focusControl);
        if (location != null) {
            contextMenu.setLocation(location);
        }
        contextMenu.setVisible(true);
        contextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                int keyIndex = 1;
                MenuItem[] menuItemArray = contextMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    if (!CommonUtils.isEmpty((String)item.getText())) {
                        item.setText(String.valueOf(String.valueOf(keyIndex)) + ". " + item.getText());
                        if (++keyIndex >= 10) break;
                    }
                    ++n2;
                }
            }
        });
        return null;
    }

    @Nullable
    private Point getLocationFromControl(Shell activeShell, Control focusControl) {
        Point location = null;
        Display display = activeShell.getDisplay();
        if (focusControl instanceof Table) {
            Table table = (Table)focusControl;
            int selectionIndex = table.getSelectionIndex();
            if (selectionIndex < 0) {
                location = display.map(focusControl, null, table.getLocation());
            } else {
                Rectangle absBounds = display.map(focusControl, null, table.getItem(selectionIndex).getBounds());
                location = new Point(absBounds.x, absBounds.y + table.getItemHeight());
            }
        } else if (focusControl instanceof Tree) {
            Tree tree = (Tree)focusControl;
            Object[] selection = tree.getSelection();
            if (ArrayUtils.isEmpty((Object[])selection)) {
                location = display.map(focusControl, null, tree.getLocation());
            } else {
                Rectangle absBounds = display.map(focusControl, null, selection[0].getBounds());
                location = new Point(absBounds.x, absBounds.y + tree.getItemHeight());
            }
        } else if (focusControl instanceof StyledText) {
            StyledText styledText = (StyledText)focusControl;
            int caretOffset = styledText.getCaretOffset();
            location = styledText.getLocationAtOffset(caretOffset);
            location = display.map((Control)styledText, null, location);
            location.y += styledText.getLineHeight();
        }
        return location;
    }
}

