/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.registry.ProjectRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;

public class ResourcePropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.resource";
    public static final String PROP_CAN_OPEN = "canOpen";
    public static final String PROP_CAN_CREATE_FOLDER = "canCreateFolder";
    public static final String PROP_CAN_CREATE_LINK = "canCreateLink";
    public static final String PROP_CAN_SET_ACTIVE = "canSetActive";
    public static final String PROP_CAN_DELETE = "canDelete";
    public static final String PROP_TYPE = "type";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IResource)) {
            return false;
        }
        IResource resource = (IResource)receiver;
        ProjectRegistry projectRegistry = DBeaverCore.getInstance().getProjectRegistry();
        DBPResourceHandler handler = projectRegistry.getResourceHandler(resource);
        if (handler == null) {
            return false;
        }
        switch (property) {
            case "canOpen": {
                return (handler.getFeatures(resource) & 1) != 0;
            }
            case "canDelete": {
                return (handler.getFeatures(resource) & 2) != 0;
            }
            case "canCreateFolder": {
                return (handler.getFeatures(resource) & 4) != 0;
            }
            case "canCreateLink": {
                return (handler.getFeatures(resource) & 4) != 0 && !resource.isLinked(512);
            }
            case "canSetActive": {
                return resource instanceof IProject && resource != projectRegistry.getActiveProject();
            }
            case "type": {
                DBPResourceHandler resourceHandler = DBeaverCore.getInstance().getProjectRegistry().getResourceHandler(resource);
                return resourceHandler != null && expectedValue.equals(resourceHandler.getTypeName(resource));
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState("org.jkiss.dbeaver.core.resource." + propName);
    }
}

