/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBIconBinary;
import org.jkiss.utils.CommonUtils;

public class ProgramInfo {
    private static final Map<String, ProgramInfo> programMap = new HashMap<String, ProgramInfo>();
    private final Program program;
    private DBIconBinary image;

    public ProgramInfo(Program program) {
        this.program = program;
    }

    public Program getProgram() {
        return this.program;
    }

    public DBPImage getImage() {
        return this.image;
    }

    public static ProgramInfo getProgram(IResource resource) {
        if (resource instanceof IFile) {
            String fileExtension = CommonUtils.notEmpty((String)resource.getFileExtension());
            ProgramInfo programInfo = programMap.get(fileExtension);
            if (programInfo == null) {
                ImageData imageData;
                Program program = Program.findProgram((String)fileExtension);
                programInfo = new ProgramInfo(program);
                if (program != null && (imageData = program.getImageData()) != null) {
                    programInfo.image = new DBIconBinary(program.getName(), imageData);
                }
                programMap.put(fileExtension, programInfo);
            }
            return programInfo.program == null ? null : programInfo;
        }
        return null;
    }
}

