/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StreamConsumerPageOutput
extends ActiveWizardPage<DataTransferWizard> {
    private Combo encodingCombo;
    private Label encodingBOMLabel;
    private Button encodingBOMCheckbox;
    private Text directoryText;
    private Text fileNameText;
    private Button compressCheckbox;
    private Button showFolderCheckbox;
    private Button execProcessCheckbox;
    private Text execProcessText;
    private Button clipboardCheck;

    public StreamConsumerPageOutput() {
        super(CoreMessages.data_transfer_wizard_output_name);
        this.setTitle(CoreMessages.data_transfer_wizard_output_title);
        this.setDescription(CoreMessages.data_transfer_wizard_output_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final StreamConsumerSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        Group generalSettings = UIUtils.createControlGroup(composite, CoreMessages.data_transfer_wizard_output_group_general, 5, 768, 0);
        this.clipboardCheck = UIUtils.createLabelCheckbox((Composite)generalSettings, "Copy to clipboard", false);
        this.clipboardCheck.setLayoutData((Object)new GridData(1, 1, false, false, 4, 1));
        this.clipboardCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOutputClipboard(StreamConsumerPageOutput.this.clipboardCheck.getSelection());
                StreamConsumerPageOutput.this.toggleClipboardOutput();
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.directoryText = DialogUtils.createOutputFolderChooser((Composite)generalSettings, null, e -> {
            settings.setOutputFolder(this.directoryText.getText());
            this.updatePageCompletion();
        });
        ((GridData)this.directoryText.getParent().getLayoutData()).horizontalSpan = 4;
        UIUtils.createControlLabel((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_label_file_name_pattern);
        this.fileNameText = new Text((Composite)generalSettings, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        UIUtils.setContentProposalToolTip((Control)this.fileNameText, "Output file name pattern", "table", "timestamp", "date", "project");
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.addModifyListener(e -> {
            settings.setOutputFilePattern(this.fileNameText.getText());
            this.updatePageCompletion();
        });
        UIUtils.installContentProposal((Control)this.fileNameText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"timestamp"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"project")}));
        UIUtils.createControlLabel((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_label_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)generalSettings, settings.getOutputEncoding());
        this.encodingCombo.addModifyListener(e -> {
            int index = this.encodingCombo.getSelectionIndex();
            if (index >= 0) {
                settings.setOutputEncoding(this.encodingCombo.getItem(index));
            }
            this.updatePageCompletion();
        });
        this.encodingBOMLabel = UIUtils.createControlLabel((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_label_insert_bom);
        this.encodingBOMLabel.setToolTipText(CoreMessages.data_transfer_wizard_output_label_insert_bom_tooltip);
        this.encodingBOMCheckbox = new Button((Composite)generalSettings, 32);
        this.encodingBOMCheckbox.setLayoutData((Object)new GridData(128, 2, true, false, 1, 1));
        this.encodingBOMCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOutputEncodingBOM(StreamConsumerPageOutput.this.encodingBOMCheckbox.getSelection());
            }
        });
        new Label((Composite)generalSettings, 0);
        this.compressCheckbox = UIUtils.createLabelCheckbox((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_checkbox_compress, false);
        this.compressCheckbox.setLayoutData((Object)new GridData(32, 2, true, false, 4, 1));
        this.compressCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompressResults(StreamConsumerPageOutput.this.compressCheckbox.getSelection());
            }
        });
        Group resultsSettings = UIUtils.createControlGroup(composite, "Results", 2, 768, 0);
        this.showFolderCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, CoreMessages.data_transfer_wizard_output_checkbox_open_folder, true);
        this.showFolderCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenFolderOnFinish(StreamConsumerPageOutput.this.showFolderCheckbox.getSelection());
            }
        });
        this.showFolderCheckbox.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        this.execProcessCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, "Execute process on finish", true);
        this.execProcessCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setExecuteProcessOnFinish(StreamConsumerPageOutput.this.execProcessCheckbox.getSelection());
                StreamConsumerPageOutput.this.toggleExecProcessControls();
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.execProcessText = new Text((Composite)resultsSettings, 2048);
        this.execProcessText.setLayoutData((Object)new GridData(768));
        this.execProcessText.addModifyListener(e -> {
            settings.setFinishProcessCommand(this.execProcessText.getText());
            this.updatePageCompletion();
        });
        UIUtils.setContentProposalToolTip((Control)this.execProcessText, "Process command line", "file", "table", "timestamp", "date", "project");
        UIUtils.installContentProposal((Control)this.execProcessText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"timestamp"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"project"), GeneralUtils.variablePattern((String)"file")}));
        this.setControl((Control)composite);
    }

    private void toggleClipboardOutput() {
        boolean clipboard = this.clipboardCheck.getSelection();
        this.directoryText.setEnabled(!clipboard);
        this.fileNameText.setEnabled(!clipboard);
        this.compressCheckbox.setEnabled(!clipboard);
        this.encodingCombo.setEnabled(!clipboard);
        this.encodingBOMLabel.setEnabled(!clipboard);
        this.encodingBOMCheckbox.setEnabled(!clipboard);
        this.showFolderCheckbox.setEnabled(!clipboard);
        this.execProcessCheckbox.setEnabled(!clipboard);
        this.execProcessText.setEnabled(!clipboard);
    }

    private void toggleExecProcessControls() {
        boolean clipboard = this.clipboardCheck.getSelection();
        boolean isExecCommand = this.execProcessCheckbox.getSelection();
        this.execProcessText.setEnabled(!clipboard && isExecCommand);
    }

    @Override
    public void activatePage() {
        StreamConsumerSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        this.clipboardCheck.setSelection(settings.isOutputClipboard());
        this.directoryText.setText(CommonUtils.toString((Object)settings.getOutputFolder()));
        this.fileNameText.setText(CommonUtils.toString((Object)settings.getOutputFilePattern()));
        this.compressCheckbox.setSelection(settings.isCompressResults());
        this.encodingCombo.setText(CommonUtils.toString((Object)settings.getOutputEncoding()));
        this.encodingBOMCheckbox.setSelection(settings.isOutputEncodingBOM());
        this.showFolderCheckbox.setSelection(settings.isOpenFolderOnFinish());
        this.execProcessCheckbox.setSelection(settings.isExecuteProcessOnFinish());
        this.execProcessText.setText(CommonUtils.toString((Object)settings.getFinishProcessCommand()));
        this.updatePageCompletion();
        this.toggleClipboardOutput();
        this.toggleExecProcessControls();
    }

    @Override
    protected boolean determinePageCompletion() {
        StreamConsumerSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        if (settings.isOutputClipboard()) {
            return true;
        }
        boolean valid = true;
        if (CommonUtils.isEmpty((String)settings.getOutputFolder())) {
            valid = false;
        }
        if (CommonUtils.isEmpty((String)settings.getOutputFilePattern())) {
            valid = false;
        }
        if (settings.isExecuteProcessOnFinish() && CommonUtils.isEmpty((String)settings.getFinishProcessCommand())) {
            return false;
        }
        return valid;
    }
}

