/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.scripts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.scripts.ScriptsImportData;
import org.jkiss.dbeaver.tools.scripts.ScriptsImportWizardPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ScriptsImportWizard
extends Wizard
implements IImportWizard {
    private static final Log log = Log.getLog(ScriptsImportWizard.class);
    private ScriptsImportWizardPage pageMain;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(CoreMessages.dialog_scripts_import_wizard_window_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.pageMain = new ScriptsImportWizardPage();
        this.addPage((IWizardPage)this.pageMain);
    }

    public boolean performFinish() {
        ScriptsImportData importData = this.pageMain.getImportData();
        ScriptsImporter importer = new ScriptsImporter(importData);
        try {
            DBeaverUI.run((IRunnableContext)this.getContainer(), true, true, importer);
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (InvocationTargetException ex) {
            DBUserInterface.getInstance().showError(CoreMessages.dialog_scripts_import_wizard_dialog_error_title, CoreMessages.dialog_scripts_import_wizard_dialog_error_text, ex.getTargetException());
            return false;
        }
        if (importer.getImportedCount() <= 0) {
            UIUtils.showMessageBox(this.getShell(), CoreMessages.dialog_scripts_import_wizard_dialog_message_title, CoreMessages.dialog_scripts_import_wizard_dialog_message_no_scripts, 8);
            return false;
        }
        UIUtils.showMessageBox(this.getShell(), CoreMessages.dialog_scripts_import_wizard_dialog_message_title, String.valueOf(importer.getImportedCount()) + CoreMessages.dialog_scripts_import_wizard_dialog_message_success_imported, 2);
        return true;
    }

    private int importScripts(DBRProgressMonitor monitor, ScriptsImportData importData) throws IOException, DBException, CoreException {
        ArrayList<Pattern> masks = new ArrayList<Pattern>();
        StringTokenizer st = new StringTokenizer(importData.getFileMasks(), ",; ");
        while (st.hasMoreTokens()) {
            String mask = st.nextToken().trim();
            if (CommonUtils.isEmpty((String)mask)) continue;
            mask = mask.replace("*", ".*");
            masks.add(Pattern.compile(mask));
        }
        ArrayList<File> filesToImport = new ArrayList<File>();
        this.collectFiles(importData.getInputDir(), masks, filesToImport);
        if (filesToImport.isEmpty()) {
            return 0;
        }
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        int imported = filesToImport.size();
        monitor.beginTask(CoreMessages.dialog_scripts_import_wizard_monitor_import_scripts, imported);
        for (File file : filesToImport) {
            IFile targetFile;
            monitor.subTask(file.getName());
            ArrayList<File> path = new ArrayList<File>();
            File parent = file.getParentFile();
            while (!parent.equals(importData.getInputDir())) {
                path.add(0, parent);
                parent = parent.getParentFile();
            }
            IResource srcResource = importData.getImportDir().getResource();
            if (!(srcResource instanceof IFolder)) {
                log.warn((Object)("Resource '" + srcResource + "' is not a folder"));
                continue;
            }
            IFolder targetDir = (IFolder)srcResource;
            for (File folder : path) {
                if ((targetDir = targetDir.getFolder(folder.getName())).exists()) continue;
                targetDir.create(true, true, (IProgressMonitor)nullMonitor);
            }
            String targetName = file.getName();
            if (!targetName.toLowerCase().endsWith(".sql")) {
                targetName = String.valueOf(targetName) + ".sql";
            }
            if ((targetFile = targetDir.getFile(targetName)).exists()) {
                if (importData.isOverwriteFiles()) {
                    log.warn((Object)("Overwriting file '" + targetFile.getFullPath() + "'"));
                    targetFile.delete(true, true, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                } else {
                    log.warn((Object)("File '" + targetFile.getFullPath() + "' already exists - skipped"));
                    --imported;
                    continue;
                }
            }
            Throwable throwable = null;
            Object var16_17 = null;
            try (FileInputStream in = new FileInputStream(file);){
                targetFile.create((InputStream)in, true, (IProgressMonitor)nullMonitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (importData.getDataSourceContainer() != null) {
                EditorUtils.setFileDataSource(targetFile, importData.getDataSourceContainer());
            }
            monitor.worked(1);
        }
        monitor.done();
        return imported;
    }

    private void collectFiles(File inputDir, List<Pattern> masks, List<File> filesToImport) {
        File[] listFiles = inputDir.listFiles();
        if (listFiles == null) {
            return;
        }
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.collectFiles(file, masks, filesToImport);
            } else {
                boolean matched = false;
                for (Pattern mask : masks) {
                    if (!mask.matcher(file.getName()).matches()) continue;
                    matched = true;
                    break;
                }
                if (matched) {
                    filesToImport.add(file);
                }
            }
            ++n2;
        }
    }

    private class ScriptsImporter
    implements DBRRunnableWithProgress {
        private final ScriptsImportData importData;
        private int importedCount;

        public ScriptsImporter(ScriptsImportData importData) {
            this.importData = importData;
        }

        public int getImportedCount() {
            return this.importedCount;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.importedCount = ScriptsImportWizard.this.importScripts(monitor, this.importData);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

