/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.project.ProjectCreateData;
import org.jkiss.dbeaver.ui.preferences.PrefPageProjectSettings;
import org.jkiss.dbeaver.ui.preferences.WizardPrefPage;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ProjectCreateWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    private ProjectCreateData data = new ProjectCreateData();
    private WizardPrefPage projectSettingsPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(CoreMessages.dialog_project_create_wizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        PrefPageProjectSettings projectSettingsPref = new PrefPageProjectSettings();
        this.projectSettingsPage = new WizardPrefPage((IPreferencePage)projectSettingsPref, "Resources", "Project resources");
        this.addPage((IWizardPage)this.projectSettingsPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof WizardNewProjectCreationPage) {
            return this.projectSettingsPage;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        if (super.performFinish()) {
            try {
                DBeaverUI.run((IRunnableContext)this.getContainer(), true, true, new DBRRunnableWithProgress(){

                    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ProjectCreateWizard.this.createProject(monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                return false;
            }
            catch (InvocationTargetException ex) {
                DBUserInterface.getInstance().showError(CoreMessages.dialog_project_create_wizard_error_cannot_create, CoreMessages.dialog_project_create_wizard_error_cannot_create_message, ex.getTargetException());
                return false;
            }
            return true;
        }
        return false;
    }

    private void createProject(DBRProgressMonitor monitor) throws DBException, CoreException {
        IProgressMonitor nestedMonitor = RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor);
        IProject project = this.getNewProject();
        IProjectDescription description = project.getDescription();
        if (!CommonUtils.isEmpty((String)this.data.getDescription())) {
            description.setComment(this.data.getDescription());
        }
        description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
        project.setDescription(description, nestedMonitor);
        if (!project.isOpen()) {
            project.open(nestedMonitor);
        }
    }
}

