/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.ILazyPropertyLoadListener;

public class PropertiesContributor {
    public static final String CATEGORY_INFO = CoreMessages.ui_properties_category_information;
    public static final String CATEGORY_STRUCT = CoreMessages.ui_properties_category_structure;
    public static final String TAB_STANDARD = "standard";
    public static final String SECTION_STANDARD = "standard";
    public static final String SECTION_ADDITIONAL = "additional";
    private static final PropertiesContributor instance = new PropertiesContributor();
    private final List<ILazyPropertyLoadListener> lazyListeners = new ArrayList<ILazyPropertyLoadListener>();

    public static PropertiesContributor getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLazyListener(ILazyPropertyLoadListener listener) {
        List<ILazyPropertyLoadListener> list = this.lazyListeners;
        synchronized (list) {
            this.lazyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLazyListener(ILazyPropertyLoadListener listener) {
        List<ILazyPropertyLoadListener> list = this.lazyListeners;
        synchronized (list) {
            this.lazyListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPropertyLoad(Object object, DBPPropertyDescriptor propertyId, Object propertyValue, boolean completed) {
        List<ILazyPropertyLoadListener> list = this.lazyListeners;
        synchronized (list) {
            if (!this.lazyListeners.isEmpty()) {
                for (ILazyPropertyLoadListener listener : this.lazyListeners) {
                    listener.handlePropertyLoad(object, propertyId, propertyValue, completed);
                }
            }
        }
    }
}

