/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.registry.transfer.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;

public class DataTransferRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataTransfer";
    private static DataTransferRegistry instance = null;
    private List<DataTransferNodeDescriptor> nodes = new ArrayList<DataTransferNodeDescriptor>();

    public static synchronized DataTransferRegistry getInstance() {
        if (instance == null) {
            instance = new DataTransferRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataTransferRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("node".equals(ext.getName())) {
                this.nodes.add(new DataTransferNodeDescriptor(ext));
            }
            ++n2;
        }
    }

    public List<DataTransferNodeDescriptor> getAvailableProducers(Collection<Class<?>> objectTypes) {
        return this.getAvailableNodes(DataTransferNodeDescriptor.NodeType.PRODUCER, objectTypes);
    }

    public List<DataTransferNodeDescriptor> getAvailableConsumers(Collection<Class<?>> objectTypes) {
        return this.getAvailableNodes(DataTransferNodeDescriptor.NodeType.CONSUMER, objectTypes);
    }

    List<DataTransferNodeDescriptor> getAvailableNodes(DataTransferNodeDescriptor.NodeType nodeType, Collection<Class<?>> objectTypes) {
        ArrayList<DataTransferNodeDescriptor> result = new ArrayList<DataTransferNodeDescriptor>();
        block0: for (DataTransferNodeDescriptor node : this.nodes) {
            if (node.getNodeType() != nodeType) continue;
            for (Class<?> objectType : objectTypes) {
                if (!node.appliesToType(objectType)) continue;
                result.add(node);
                continue block0;
            }
        }
        return result;
    }

    public DataTransferNodeDescriptor getNodeByType(Class<? extends IDataTransferNode> type) {
        for (DataTransferNodeDescriptor node : this.nodes) {
            if (!node.getNodeClass().equals(type)) continue;
            return node;
        }
        return null;
    }

    public DataTransferNodeDescriptor getNodeById(String id) {
        for (DataTransferNodeDescriptor node : this.nodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }
}

