/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterRegistry;
import org.jkiss.dbeaver.registry.sql.SQLFormatterConfigurer;
import org.jkiss.dbeaver.registry.sql.SQLFormatterDescriptor;

public class SQLFormatterConfigurationRegistry
implements SQLFormatterRegistry {
    private static final Log log = Log.getLog(SQLFormatterConfigurationRegistry.class);
    private static final String TAG_FORMATTER = "formatter";
    private static SQLFormatterConfigurationRegistry instance = null;
    private final List<SQLFormatterDescriptor> formatters = new ArrayList<SQLFormatterDescriptor>();

    public static synchronized SQLFormatterConfigurationRegistry getInstance() {
        if (instance == null) {
            instance = new SQLFormatterConfigurationRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLFormatterConfigurationRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlFormatter");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_FORMATTER.equals(ext.getName())) {
                this.formatters.add(new SQLFormatterDescriptor(ext));
            }
            ++n2;
        }
    }

    public void dispose() {
        this.formatters.clear();
    }

    public List<SQLFormatterDescriptor> getFormatters() {
        return this.formatters;
    }

    public SQLFormatterDescriptor getFormatter(String id) {
        for (SQLFormatterDescriptor formatter : this.formatters) {
            if (!formatter.getId().equalsIgnoreCase(id)) continue;
            return formatter;
        }
        return null;
    }

    @Nullable
    public SQLFormatter createFormatter(SQLFormatterConfiguration configuration) {
        String formatterId = configuration.getFormatterId();
        SQLFormatterDescriptor formatterDesc = this.getFormatter(formatterId);
        if (formatterDesc == null) {
            log.error((Object)("Formatter '" + formatterId + "' not found"));
            return null;
        }
        try {
            return formatterDesc.createFormatter();
        }
        catch (DBException e) {
            log.error((Object)"Error creating formatter", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public SQLFormatter createAndConfigureFormatter(SQLFormatterConfiguration configuration) {
        SQLFormatter formatter;
        block4: {
            String formatterId = configuration.getFormatterId();
            SQLFormatterDescriptor formatterDesc = this.getFormatter(formatterId);
            if (formatterDesc == null) {
                log.error((Object)("Formatter '" + formatterId + "' not found"));
                return null;
            }
            try {
                formatter = formatterDesc.createFormatter();
                SQLFormatterConfigurer configurer = formatterDesc.createConfigurer();
                if (configurer == null || configurer.configure(formatterDesc.getLabel(), formatter, configuration)) break block4;
                return null;
            }
            catch (DBException e) {
                log.error((Object)"Error creating and configuring formatter", (Throwable)e);
                return null;
            }
        }
        return formatter;
    }
}

