/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.registry.sql.SQLTargetConverterDescriptor;

public class SQLConverterRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sql.covert";
    private static final String TAG_TARGET = "target";
    private static SQLConverterRegistry instance;
    private List<SQLTargetConverterDescriptor> targetConverters = new ArrayList<SQLTargetConverterDescriptor>();

    public static synchronized SQLConverterRegistry getInstance() {
        if (instance == null) {
            instance = new SQLConverterRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLConverterRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] panelElements;
        IConfigurationElement[] iConfigurationElementArray = panelElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = panelElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_TARGET.equals(ext.getName())) {
                SQLTargetConverterDescriptor descriptor = new SQLTargetConverterDescriptor(ext);
                this.targetConverters.add(descriptor);
            }
            ++n2;
        }
    }

    @NotNull
    public List<SQLTargetConverterDescriptor> getTargetConverters() {
        return this.targetConverters;
    }

    @Nullable
    public SQLTargetConverterDescriptor getTargetConverter(String converterId) {
        for (SQLTargetConverterDescriptor converter : this.targetConverters) {
            if (!converter.getId().equals(converterId)) continue;
            return converter;
        }
        return null;
    }
}

