/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.util.Collection;
import java.util.StringTokenizer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class DriverUtils {
    public static boolean isBetaVersion(@NotNull String versionInfo) {
        return versionInfo.contains("beta") || versionInfo.contains("alpha");
    }

    @Nullable
    public static String findLatestVersion(@NotNull Collection<String> allVersions) {
        String latest = null;
        for (String version : allVersions) {
            if (DriverUtils.isBetaVersion(version) || latest != null && DriverUtils.compareVersions(version, latest) <= 0) continue;
            latest = version;
        }
        if (latest == null) {
            for (String version : allVersions) {
                if (latest != null && DriverUtils.compareVersions(version, latest) <= 0) continue;
                latest = version;
            }
        }
        return latest;
    }

    public static int compareVersions(@NotNull String v1, @NotNull String v2) {
        StringTokenizer st1 = new StringTokenizer(v1, ".-_");
        StringTokenizer st2 = new StringTokenizer(v2, ".-_");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            String t1 = st1.nextToken();
            String t2 = st2.nextToken();
            try {
                int cmp = Integer.parseInt(t1) - Integer.parseInt(t2);
                if (cmp == 0) continue;
                return cmp;
            }
            catch (NumberFormatException e) {
                int cmp = t1.compareTo(t2);
                if (cmp == 0) continue;
                return cmp;
            }
        }
        if (st1.hasMoreTokens()) {
            return 1;
        }
        if (st2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }
}

