/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;

public class DataSourceViewDescriptor
extends AbstractDescriptor {
    private String id;
    private String targetID;
    private String label;
    private AbstractDescriptor.ObjectType viewType;
    private DBPImage icon;

    public DataSourceViewDescriptor(DataSourceProviderDescriptor provider, IConfigurationElement config) {
        super(provider.getPluginId());
        this.id = config.getAttribute("id");
        this.targetID = config.getAttribute("targetID");
        this.label = config.getAttribute("label");
        this.viewType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
    }

    public String getId() {
        return this.id;
    }

    public String getTargetID() {
        return this.targetID;
    }

    public String getLabel() {
        return this.label;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public <T> T createView(Class<T> implementsClass) {
        try {
            return (T)this.viewType.createInstance(implementsClass);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't create view '" + this.viewType.getImplName() + "'", ex);
        }
    }
}

