/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IDisposable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.WorkbenchContextListener;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthInfo;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProcessListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DummyRunnableContext;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.TrayIconHandler;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceInvalidateHandler;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.BaseAuthDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.ui.views.process.ProcessPropertyTester;
import org.jkiss.dbeaver.ui.views.process.ShellProcessView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DBeaverUI
implements DBPPlatformUI {
    private static final Log log = Log.getLog(DBeaverUI.class);
    private static DBeaverUI instance;
    private SharedTextColors sharedTextColors;
    private TrayIconHandler trayItem;
    private final List<IDisposable> globalDisposables = new ArrayList<IDisposable>();

    public static DBeaverUI getInstance() {
        if (instance == null) {
            instance = new DBeaverUI();
            instance.initialize();
        }
        return instance;
    }

    static void disposeUI() {
        if (instance != null) {
            try {
                instance.dispose();
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    public static SharedTextColors getSharedTextColors() {
        return DBeaverUI.getInstance().sharedTextColors;
    }

    public static void run(IRunnableContext runnableContext, boolean fork, boolean cancelable, final DBRRunnableWithProgress runnableWithProgress) throws InvocationTargetException, InterruptedException {
        runnableContext.run(fork, cancelable, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                runnableWithProgress.run((Object)RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
            }
        });
    }

    private void dispose() {
        this.sharedTextColors.dispose();
        if (this.trayItem != null) {
            this.trayItem.hide();
        }
        ArrayList<IDisposable> dispList = new ArrayList<IDisposable>(this.globalDisposables);
        Collections.reverse(dispList);
        for (IDisposable disp : dispList) {
            try {
                disp.dispose();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            this.globalDisposables.remove(disp);
        }
    }

    private void initialize() {
        this.sharedTextColors = new SharedTextColors();
        this.trayItem = new TrayIconHandler();
        DBUserInterface.setInstance((DBPPlatformUI)this);
        WorkbenchContextListener.registerInWorkbench();
    }

    public static AbstractUIJob runUIJob(String jobName, DBRRunnableWithProgress runnableWithProgress) {
        return DBeaverUI.runUIJob(jobName, 0, runnableWithProgress);
    }

    public static AbstractUIJob runUIJob(String jobName, int timeout, final DBRRunnableWithProgress runnableWithProgress) {
        AbstractUIJob job = new AbstractUIJob(jobName){

            @Override
            public IStatus runInUIThread(DBRProgressMonitor monitor) {
                try {
                    runnableWithProgress.run((Object)monitor);
                }
                catch (InvocationTargetException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(timeout);
        return job;
    }

    @NotNull
    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0];
        }
        throw new IllegalStateException("No workbench window");
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return Display.getDefault().getActiveShell();
    }

    public static Display getDisplay() {
        try {
            return PlatformUI.getWorkbench().getDisplay();
        }
        catch (Exception e) {
            return Display.getDefault();
        }
    }

    public static DBRRunnableContext getDefaultRunnableContext() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && workbench.getActiveWorkbenchWindow() != null) {
            return new RunnableContextDelegate((IRunnableContext)workbench.getActiveWorkbenchWindow());
        }
        return new DBRRunnableContext(){

            public void run(boolean fork, boolean cancelable, DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run((Object)new VoidProgressMonitor());
            }
        };
    }

    public static void runInProgressService(final DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        DBeaverUI.getDefaultRunnableContext().run(true, true, new DBRRunnableWithProgress(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                runnable.run((Object)monitor);
            }
        });
    }

    public static void runInProgressDialog(final DBRRunnableWithProgress runnable) throws InvocationTargetException {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            Object runnableContext = workbenchWindow != null ? new ProgressMonitorDialog(workbench.getActiveWorkbenchWindow().getShell()) : workbench.getProgressService();
            runnableContext.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    runnable.run((Object)RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void runInUI(IRunnableContext context, final DBRRunnableWithProgress runnable) {
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI(context, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    runnable.run((Object)RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
                }
            }, (ISchedulingRule)DBeaverActivator.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            DBUserInterface.getInstance().showError(null, null, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void runInUI(DBRRunnableWithProgress runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchWindow context = window != null ? window : DummyRunnableContext.INSTANCE;
        DBeaverUI.runInUI((IRunnableContext)context, runnable);
    }

    public static void asyncExec(Runnable runnable) {
        try {
            DBeaverUI.getDisplay().asyncExec(runnable);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public static void syncExec(Runnable runnable) {
        try {
            DBeaverUI.getDisplay().syncExec(runnable);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public static <T> T syncExec(RunnableWithResult<T> runnable) {
        try {
            DBeaverUI.getDisplay().syncExec(runnable);
            return (T)runnable.getResult();
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    public static void notifyAgent(String message, int status) {
        if (!DBeaverCore.getGlobalPreferenceStore().getBoolean("agent.long.operation.notify")) {
            return;
        }
        DBeaverUI.getInstance().trayItem.notify(message, status);
    }

    public DBPPlatformUI.UserResponse showError(final @NotNull String title, final @Nullable String message, final @NotNull IStatus status) {
        IStatus s = status;
        while (s != null) {
            if (s.getException() instanceof DBException) {
                DBPPlatformUI.UserResponse dbErrorResp = DBeaverUI.showDatabaseError(message, (DBException)s.getException());
                if (dbErrorResp == null) break;
                return dbErrorResp;
            }
            if (s.getChildren() == null || s.getChildren().length <= 0) break;
            s = s.getChildren()[0];
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StandardErrorDialog dialog = new StandardErrorDialog(DBeaverUI.getActiveWorkbenchShell(), title, message, RuntimeUtils.stripStack((IStatus)status), 4);
                dialog.open();
            }
        };
        DBeaverUI.syncExec(runnable);
        return DBPPlatformUI.UserResponse.OK;
    }

    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull Throwable error) {
        log.error((Object)error);
        return this.showError(title, message, GeneralUtils.makeExceptionStatus((Throwable)error));
    }

    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message) {
        return this.showError(title, null, (IStatus)new Status(4, "org.jkiss.dbeaver.core", message));
    }

    private static DBPPlatformUI.UserResponse showDatabaseError(String message, DBException error) {
        DBPDataSource dataSource = error.getDataSource();
        DBPErrorAssistant.ErrorType errorType = dataSource == null ? DBPErrorAssistant.ErrorType.NORMAL : DBUtils.discoverErrorType((DBPDataSource)dataSource, (Throwable)error);
        switch (errorType) {
            case CONNECTION_LOST: {
                if (dataSource.getContainer().getDataSource() == null) {
                    return null;
                }
                DataSourceInvalidateHandler.showConnectionLostDialog(null, message, error);
                return DBPPlatformUI.UserResponse.OK;
            }
            case DRIVER_CLASS_MISSING: {
                DriverEditDialog.showBadConfigDialog(null, message, error);
                return DBPPlatformUI.UserResponse.OK;
            }
        }
        return null;
    }

    public DBAAuthInfo promptUserCredentials(final String prompt, final String userName, final String userPassword, final boolean passwordOnly) {
        return (DBAAuthInfo)new UITask<DBAAuthInfo>(){

            @Override
            public DBAAuthInfo runTask() {
                Shell shell = DBeaverUI.getActiveWorkbenchShell();
                BaseAuthDialog authDialog = new BaseAuthDialog(shell, prompt, passwordOnly);
                if (!passwordOnly) {
                    authDialog.setUserName(userName);
                }
                authDialog.setUserPassword(userPassword);
                if (authDialog.open() == 0) {
                    return authDialog.getAuthInfo();
                }
                return null;
            }
        }.execute();
    }

    public void executeProcess(final DBRProcessDescriptor processDescriptor) {
        processDescriptor.setProcessListener(new DBRProcessListener(){

            public void onProcessStarted() {
                ProcessPropertyTester.firePropertyChange("running");
            }

            public void onProcessTerminated(int resultCode) {
                ProcessPropertyTester.firePropertyChange("running");
            }
        });
        try {
            processDescriptor.execute();
        }
        catch (DBException e) {
            this.showError("Execute process", processDescriptor.getName(), e);
        }
        if (processDescriptor.getCommand().isShowProcessPanel()) {
            DBeaverUI.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ShellProcessView processView = (ShellProcessView)DBeaverUI.getActiveWorkbenchWindow().getActivePage().showView("org.jkiss.dbeaver.core.shellProcess", ShellProcessView.getNextId(), 2);
                        processView.initProcess(processDescriptor);
                    }
                    catch (PartInitException e) {
                        log.error((Object)e);
                    }
                }
            });
        }
    }

    public void executeInUI(Runnable runnable) {
        DBeaverUI.syncExec(runnable);
    }
}

