/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tools.maintenance;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablespaceDataType;
import org.jkiss.dbeaver.ext.db2.tools.maintenance.DB2BaseTableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;

public class DB2ReorgTableDialog
extends DB2BaseTableToolDialog {
    private String indexName;
    private String tempTablespace;
    private String lobsTablespace;
    private Button dlgInplace;
    private Button dlgUseIndex;
    private Combo indexesCombo;
    private Button dlgTruncate;
    private Button dlgUseTempTS;
    private Combo tempTSCombo;
    private Button dlgIndexScan;
    private Button dlgReorgLobsTS;
    private Button dlgUseLobsTemp;
    private Combo tempLobsTSCombo;
    private Button dlgResetDictionary;
    private Button dlgAccesNo;
    private Button dlgAccesReadOnly;
    private Button dlgAccesReadWrite;
    private final List<String> listTempTsNames = new ArrayList<String>();
    private final List<String> listIndexNames = new ArrayList<String>();

    public DB2ReorgTableDialog(IWorkbenchPartSite partSite, final Collection<DB2Table> selectedTables) {
        super(partSite, DB2Messages.dialog_table_tools_reorg_title, selectedTables);
        try {
            DBeaverUI.runInProgressService((DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DB2Table db2Table = (DB2Table)selectedTables.iterator().next();
                    DB2DataSource db2DataSource = (DB2DataSource)db2Table.getDataSource();
                    try {
                        monitor.beginTask("Read system info", 2);
                        for (DB2Tablespace db2Tablespace : db2DataSource.getTablespaces(monitor)) {
                            if (!db2Tablespace.getDataType().equals((Object)DB2TablespaceDataType.T)) continue;
                            DB2ReorgTableDialog.this.listTempTsNames.add(db2Tablespace.getName());
                        }
                        monitor.worked(1);
                        for (DB2Index db2Index : db2Table.getIndexes(monitor)) {
                            DB2ReorgTableDialog.this.listIndexNames.add(db2Index.getFullyQualifiedName(DBPEvaluationContext.DDL));
                        }
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBUserInterface.getInstance().showError("Error", "Can't read system info", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void createControls(Composite parent) {
        Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)DB2Messages.dialog_table_tools_options, (int)1, (int)0, (int)0);
        optionsGroup.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)optionsGroup, 2);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.dlgInplace = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_inplace, (boolean)false);
        this.dlgInplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DB2ReorgTableDialog.this.dlgInplace.getSelection()) {
                    DB2ReorgTableDialog.this.dlgTruncate.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgTruncate.setSelection(true);
                    DB2ReorgTableDialog.this.dlgUseTempTS.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgIndexScan.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgReorgLobsTS.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgUseLobsTemp.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgResetDictionary.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgAccesReadWrite.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgAccesNo.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgAccesNo.setSelection(false);
                    DB2ReorgTableDialog.this.dlgAccesReadWrite.setSelection(false);
                    DB2ReorgTableDialog.this.dlgAccesReadOnly.setSelection(true);
                } else {
                    DB2ReorgTableDialog.this.dlgTruncate.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgTruncate.setSelection(false);
                    DB2ReorgTableDialog.this.dlgUseTempTS.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgIndexScan.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgReorgLobsTS.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgUseLobsTemp.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgResetDictionary.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgAccesNo.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgAccesReadWrite.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgAccesReadWrite.setSelection(false);
                    DB2ReorgTableDialog.this.dlgAccesReadOnly.setSelection(false);
                    DB2ReorgTableDialog.this.dlgAccesNo.setSelection(true);
                }
                DB2ReorgTableDialog.this.updateSQL();
            }
        });
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.dlgUseIndex = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_useindex, (boolean)false);
        this.dlgUseIndex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DB2ReorgTableDialog.this.dlgUseIndex.getSelection()) {
                    DB2ReorgTableDialog.this.indexesCombo.setEnabled(true);
                    DB2ReorgTableDialog.this.dlgIndexScan.setEnabled(true);
                } else {
                    DB2ReorgTableDialog.this.indexesCombo.setEnabled(false);
                    DB2ReorgTableDialog.this.dlgIndexScan.setEnabled(false);
                }
                DB2ReorgTableDialog.this.updateSQL();
            }
        });
        this.indexesCombo = this.createIndexesCombo(composite);
        this.dlgIndexScan = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_useindexscan, (boolean)false);
        this.dlgIndexScan.addSelectionListener(this.SQL_CHANGE_LISTENER);
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.dlgTruncate = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_truncate, (boolean)false);
        this.dlgTruncate.addSelectionListener(this.SQL_CHANGE_LISTENER);
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.dlgUseTempTS = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_usetempts, (boolean)false);
        this.dlgUseTempTS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DB2ReorgTableDialog.this.dlgUseTempTS.getSelection()) {
                    DB2ReorgTableDialog.this.tempTSCombo.setEnabled(true);
                } else {
                    DB2ReorgTableDialog.this.tempTSCombo.setEnabled(false);
                }
                DB2ReorgTableDialog.this.updateSQL();
            }
        });
        this.tempTSCombo = this.createTempTablespaceCombo(composite);
        this.dlgReorgLobsTS = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_reorglobs, (boolean)false);
        this.dlgReorgLobsTS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DB2ReorgTableDialog.this.dlgReorgLobsTS.getSelection()) {
                    DB2ReorgTableDialog.this.dlgUseLobsTemp.setEnabled(true);
                    DB2ReorgTableDialog.this.tempLobsTSCombo.setEnabled(false);
                } else {
                    DB2ReorgTableDialog.this.dlgUseLobsTemp.setEnabled(false);
                    DB2ReorgTableDialog.this.tempLobsTSCombo.setEnabled(false);
                }
                DB2ReorgTableDialog.this.updateSQL();
            }
        });
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.dlgUseLobsTemp = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_reorglobsts, (boolean)false);
        this.dlgUseLobsTemp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DB2ReorgTableDialog.this.dlgUseLobsTemp.getSelection()) {
                    DB2ReorgTableDialog.this.tempLobsTSCombo.setEnabled(true);
                } else {
                    DB2ReorgTableDialog.this.tempLobsTSCombo.setEnabled(false);
                }
                DB2ReorgTableDialog.this.updateSQL();
            }
        });
        this.tempLobsTSCombo = this.createLobsTempTablespaceCombo(composite);
        this.dlgResetDictionary = UIUtils.createCheckbox((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_resetdict, (boolean)false);
        this.dlgResetDictionary.addSelectionListener(this.SQL_CHANGE_LISTENER);
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        UIUtils.createLabel((Composite)composite, (String)DB2Messages.dialog_table_tools_reorg_access_title);
        Composite groupRB = new Composite(composite, 0);
        groupRB.setLayout((Layout)new RowLayout());
        this.dlgAccesNo = new Button(groupRB, 16);
        this.dlgAccesNo.setText(DB2Messages.dialog_table_tools_reorg_access_no);
        this.dlgAccesNo.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgAccesReadOnly = new Button(groupRB, 16);
        this.dlgAccesReadOnly.setText(DB2Messages.dialog_table_tools_reorg_access_read);
        this.dlgAccesReadOnly.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgAccesReadWrite = new Button(groupRB, 16);
        this.dlgAccesReadWrite.setText(DB2Messages.dialog_table_tools_reorg_access_readwrite);
        this.dlgAccesReadWrite.addSelectionListener(this.SQL_CHANGE_LISTENER);
        this.dlgTruncate.setEnabled(false);
        this.dlgIndexScan.setEnabled(false);
        this.dlgUseLobsTemp.setEnabled(false);
        this.tempLobsTSCombo.setEnabled(false);
        this.dlgAccesReadWrite.setEnabled(false);
        this.dlgAccesReadOnly.setSelection(true);
        this.indexName = this.listIndexNames.isEmpty() ? null : this.listIndexNames.get(0);
        this.tempTablespace = this.listTempTsNames.isEmpty() ? null : this.listTempTsNames.get(0);
        this.lobsTablespace = this.listTempTsNames.isEmpty() ? null : this.listTempTsNames.get(0);
        this.createObjectsSelector(parent);
    }

    private Combo createIndexesCombo(Composite parent) {
        final Combo combo = new Combo(parent, 12);
        combo.setLayoutData((Object)new GridData(768));
        for (String indexName : this.listIndexNames) {
            combo.add(indexName);
        }
        combo.select(0);
        combo.setEnabled(false);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DB2ReorgTableDialog.this.indexName = (String)DB2ReorgTableDialog.this.listIndexNames.get(combo.getSelectionIndex());
                DB2ReorgTableDialog.this.updateSQL();
            }
        });
        return combo;
    }

    private Combo createTempTablespaceCombo(Composite parent) {
        final Combo combo = new Combo(parent, 12);
        combo.setLayoutData((Object)new GridData(768));
        for (String tablespaceName : this.listTempTsNames) {
            combo.add(tablespaceName);
        }
        combo.select(0);
        combo.setEnabled(false);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DB2ReorgTableDialog.this.tempTablespace = (String)DB2ReorgTableDialog.this.listTempTsNames.get(combo.getSelectionIndex());
                DB2ReorgTableDialog.this.updateSQL();
            }
        });
        return combo;
    }

    private Combo createLobsTempTablespaceCombo(Composite parent) {
        final Combo combo = new Combo(parent, 12);
        combo.setLayoutData((Object)new GridData(768));
        for (String tablespaceName : this.listTempTsNames) {
            combo.add(tablespaceName);
        }
        if (!this.listTempTsNames.isEmpty()) {
            combo.select(0);
        }
        combo.setEnabled(false);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DB2ReorgTableDialog.this.lobsTablespace = (String)DB2ReorgTableDialog.this.listTempTsNames.get(combo.getSelectionIndex());
                DB2ReorgTableDialog.this.updateSQL();
            }
        });
        return combo;
    }

    protected void generateObjectCommand(List<String> lines, DB2Table db2Table) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CALL SYSPROC.ADMIN_CMD('");
        sb.append("REORG TABLE ").append(db2Table.getFullyQualifiedName(DBPEvaluationContext.DDL));
        if (this.dlgUseIndex.getSelection() && this.indexName != null) {
            sb.append(" INDEX ").append(this.indexName);
        }
        if (this.dlgInplace.getSelection()) {
            sb.append(" INPLACE");
            if (this.dlgAccesReadOnly.getSelection()) {
                sb.append(" ALLOW READ ACCESS");
            }
            sb.append(" START");
            if (!this.dlgTruncate.getSelection()) {
                sb.append(" NO TRUNCATE TABLE");
            }
        } else {
            if (this.dlgAccesNo.getSelection()) {
                sb.append(" ALLOW NO ACCESS");
            }
            if (this.dlgUseTempTS.getSelection() && this.tempTablespace != null) {
                sb.append(" USE ").append(this.tempTablespace);
            }
            if (this.dlgIndexScan.getSelection()) {
                sb.append(" INDEXSCAN");
            }
            if (this.dlgReorgLobsTS.getSelection()) {
                sb.append(" LONGLOBDATA");
            }
            if (this.dlgUseLobsTemp.getSelection() && this.lobsTablespace != null) {
                sb.append(" USE ").append(this.lobsTablespace);
            }
            if (this.dlgResetDictionary.getSelection()) {
                sb.append(" RESETDICTIONARY");
            }
        }
        sb.append("')");
        lines.add(sb.toString());
    }
}

